/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.ModuleCache;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;

public class MapToProjectOperation
implements ICloudFoundryOperation {
    private final CloudFoundryApplicationModule appModule;
    private final CloudFoundryServer cloudServer;
    private Shell shell;

    public MapToProjectOperation(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, Shell shell) {
        this.appModule = appModule;
        this.cloudServer = cloudServer;
        this.shell = shell;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        final IProject[] selectedProject = new IProject[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                selectedProject[0] = MapToProjectOperation.this.selectReplaceProject(MapToProjectOperation.this.cloudServer, MapToProjectOperation.this.appModule);
            }
        });
        if (selectedProject[0] != null) {
            this.map(selectedProject[0], monitor);
        }
    }

    public void map(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project == null || !project.isAccessible()) {
            throw CloudErrorUtil.toCoreException((String)"No accessible project specified. Unable to link the cloud module with the project.");
        }
        if (this.appModule == null) {
            throw CloudErrorUtil.toCoreException((String)("No Cloud module specified. Unable to link cloud module with the project: " + project.getName()));
        }
        ModuleCache moduleCache = CloudFoundryPlugin.getModuleCache();
        ModuleCache.ServerData data = moduleCache.getData(this.cloudServer.getServerOriginal());
        if (data.isUndeployed(this.appModule.getLocalModule())) {
            throw CloudErrorUtil.toCoreException((String)"Unable to unlink the module. It is currently being published. Please wait until the publish operation is complete before relinking the project.");
        }
        data.tagForReplace(this.appModule);
        try {
            this.doMap(project, monitor);
        }
        finally {
            data.untagForReplace(this.appModule);
        }
    }

    protected void doMap(IProject project, IProgressMonitor monitor) throws CoreException {
        CloudFoundryApplicationModule updatedModule;
        IServer server = this.cloudServer.getServer();
        IServerWorkingCopy wc = server.createWorkingCopy();
        IModule[] modules = ServerUtil.getModules((IProject)project);
        if (modules == null || modules.length == 0) {
            throw CloudErrorUtil.toCoreException((String)("Unable to create module for " + project.getName() + ". Failed to link the project with " + this.appModule.getDeployedApplicationName()));
        }
        if (ServerUtil.containsModule((IServer)server, (IModule)modules[0], (IProgressMonitor)monitor)) {
            throw CloudErrorUtil.toCoreException((String)("Unable to create module for " + project.getName() + ". Module already exists. Failed to link the project with " + this.appModule.getDeployedApplicationName()));
        }
        IModule[] add = new IModule[]{modules[0]};
        ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])add, (IModule[])new IModule[]{this.appModule.getLocalModule()}, (IProgressMonitor)monitor);
        wc.save(true, monitor);
        CloudFoundryServerBehaviour behaviour = this.cloudServer.getBehaviour();
        if (behaviour != null) {
            behaviour.cleanModuleStates(add, monitor);
        }
        if ((updatedModule = this.cloudServer.getExistingCloudModule(this.appModule.getDeployedApplicationName())) != null) {
            this.cloudServer.getBehaviour().operations().updateModuleWithAllCloudInfo(updatedModule.getLocalModule()).run(monitor);
        }
        ServerEventHandler.getDefault().fireServerRefreshed(this.cloudServer);
    }

    protected IProject selectReplaceProject(final CloudFoundryServer cloudServer, final CloudFoundryApplicationModule appModule) {
        final String appToBeMappedName = appModule.getDeployedApplicationName();
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                IProject potentialProject = null;
                if (element instanceof IProject) {
                    potentialProject = (IProject)element;
                }
                if (potentialProject == null || !potentialProject.isAccessible()) {
                    return false;
                }
                if (!CloudFoundryServer.isNonfacetedModule((IModule)appModule)) {
                    try {
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)potentialProject);
                        if (facetedProject == null) {
                            return false;
                        }
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                if (appToBeMappedName.equals(potentialProject.getName())) {
                    return true;
                }
                IModule[] allModules = cloudServer.getServerOriginal().getModules();
                if (allModules != null) {
                    IModule[] iModuleArray = allModules;
                    int n = allModules.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModule mod = iModuleArray[n2];
                        if (mod.getProject() != null && mod.getProject().equals((Object)potentialProject)) {
                            return false;
                        }
                        if (mod.getName().equals(potentialProject.getName())) {
                            return false;
                        }
                        ++n2;
                    }
                }
                return true;
            }
        };
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object ob1, Object ob2) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object ob1) {
                return false;
            }

            public Object getParent(Object ob1) {
                return null;
            }

            public Object[] getElements(Object elements) {
                if (elements instanceof IProject[]) {
                    return (IProject[])elements;
                }
                return null;
            }

            public Object[] getChildren(Object parent) {
                return null;
            }
        };
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.shell, (ILabelProvider)labelProvider, contentProvider){

            protected Label createMessageArea(Composite composite) {
                Label label = new Label(composite, 64);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.widthHint = composite.getShell().getSize().x / 5;
                label.setLayoutData((Object)gd);
                String msg = this.getMessage();
                if (msg != null) {
                    label.setText(msg);
                }
                label.setFont(composite.getFont());
                return label;
            }
        };
        dialog.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        dialog.setTitle(Messages.MapToProjectOperation_PROJECT_SELECTION_DIALOGUE_TITLE);
        dialog.setMessage(NLS.bind((String)Messages.MapToProjectOperation_PROJECT_SELECTION_DIALOGUE_MESSAGE, (Object)appModule.getDeployedApplicationName()));
        dialog.addFilter(viewerFilter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects());
        dialog.setInitialSelection(null);
        dialog.setHelpAvailable(false);
        IProject selectProj = null;
        if (dialog.open() == 0) {
            Object selectObj = dialog.getFirstResult();
            if (selectObj instanceof IProject) {
                selectProj = (IProject)selectObj;
            }
            final boolean[] result = new boolean[1];
            final IProject selProj = selectProj;
            if (selProj != null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = MessageDialog.openConfirm((Shell)MapToProjectOperation.this.shell, (String)Messages.MapToProjectOperation_PROJECT_SELECTION_CONFIRM_DIALOGUE_TITLE, (String)NLS.bind((String)Messages.MapToProjectOperation_PROJECT_SELECTION_CONFIRM_DIALOGUE_MESSAGE, (Object)selProj.getName(), (Object)appModule.getDeployedApplicationName()));
                    }
                });
            }
            if (result[0]) {
                return selectProj;
            }
        }
        return null;
    }
}

