/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.UpdatePasswordDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UpdatePasswordOperation
implements ICloudFoundryOperation {
    private final CloudFoundryServer cloudServer;

    public UpdatePasswordOperation(CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        final String[] updatedPassword = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = CloudUiUtil.getShell();
                if (shell == null || shell.isDisposed()) {
                    CloudFoundryPlugin.logError((String)"No shell available to open update password dialogue");
                    return;
                }
                UpdatePasswordDialog dialog = new UpdatePasswordDialog(shell, UpdatePasswordOperation.this.cloudServer.getUsername(), UpdatePasswordOperation.this.cloudServer.getServer().getId());
                if (dialog.open() == 0) {
                    updatedPassword[0] = dialog.getPassword();
                }
            }
        });
        if (updatedPassword[0] != null) {
            this.cloudServer.setAndSavePassword(updatedPassword[0]);
            final IStatus[] changeStatus = new IStatus[]{Status.OK_STATUS};
            try {
                this.cloudServer.getBehaviour().reconnect(monitor);
            }
            catch (CoreException e) {
                changeStatus[0] = e.getStatus();
            }
            ServerEventHandler.getDefault().firePasswordUpdated(this.cloudServer, changeStatus[0]);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!changeStatus[0].isOK()) {
                        if (changeStatus[0].getException() != null) {
                            CloudFoundryPlugin.logError((Throwable)changeStatus[0].getException());
                        }
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.UpdatePasswordDialog_ERROR_VERIFY_PW_TITLE, (String)NLS.bind((String)Messages.UpdatePasswordCommand_ERROR_PW_UPDATE_BODY, (Object)changeStatus[0].getMessage()));
                    } else {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.UpdatePasswordCommand_TEXT_PW_UPDATE, (String)Messages.UpdatePasswordCommand_TEXT_PW_UPDATE_SUCC);
                    }
                }
            });
        }
    }
}

