/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.BaseCommandHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IURLProvider;

public class OpenHomePageCommand
extends BaseCommandHandler {
    private String TITLE = Messages.OpenHomePageCommand_TEXT_OPEN_HOME_TITLE;
    private String DESCRIPTION = Messages.OpenHomePageCommand_TEXT_OPEN_HOME_LABEL;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block14: {
            int state;
            CloudFoundryApplicationModule cloudModule;
            this.initializeSelection(event);
            if (this.selectedServer != null && (cloudModule = this.getSelectedCloudAppModule()) != null && (state = cloudModule.getState()) == 2) {
                IModule[][] launchables;
                IURLProvider cloudServer = (IURLProvider)this.selectedServer.loadAdapter(IURLProvider.class, null);
                CloudFoundryServer cfs = (CloudFoundryServer)this.selectedServer.loadAdapter(CloudFoundryServer.class, null);
                String contextRoot = null;
                if (cfs != null && (launchables = cfs.getLaunchableModules(this.selectedModule)) != null) {
                    if (launchables.length == 1) {
                        contextRoot = cfs.getLaunchableModuleContextRoot(launchables[0]);
                    } else if (launchables.length > 1) {
                        ArrayList<String> selectionOptions = new ArrayList<String>();
                        HashMap<String, String> index = new HashMap<String, String>();
                        int i = 0;
                        while (i < launchables.length) {
                            String option = "";
                            int j = 0;
                            while (j < launchables[i].length) {
                                option = String.valueOf(option) + launchables[i][j].getName() + "/";
                                ++j;
                            }
                            if (option.endsWith("/")) {
                                option = option.substring(0, option.length() - 1);
                            }
                            selectionOptions.add(option);
                            index.put(option, String.valueOf(i));
                            ++i;
                        }
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (ILabelProvider)new LabelProvider());
                        dialog.setTitle(this.TITLE);
                        dialog.setMessage(this.DESCRIPTION);
                        dialog.setElements(selectionOptions.toArray());
                        if (dialog.open() != 0) {
                            if (dialog.getReturnCode() == 1) {
                                CloudFoundryPlugin.logWarning((String)"User pressed cancel on selection dialog");
                                return null;
                            }
                            CloudFoundryPlugin.logError((String)"Failed to open the Open Home Page selection dialog");
                            return null;
                        }
                        Object[] result = dialog.getResult();
                        contextRoot = cfs.getLaunchableModuleContextRoot(launchables[Integer.valueOf((String)index.get(result[0]))]);
                    }
                }
                try {
                    URL homePageUrl = cloudServer.getModuleRootURL(this.selectedModule);
                    if (contextRoot != null) {
                        homePageUrl = new URL(homePageUrl, contextRoot);
                    }
                    if (homePageUrl != null) {
                        CloudUiUtil.openUrl(homePageUrl.toExternalForm());
                        break block14;
                    }
                    CloudFoundryPlugin.logError((String)"homePageUrl is null, unable to launch the Home Page URL");
                    return null;
                }
                catch (Exception e) {
                    CloudFoundryPlugin.logError((String)"Cannot launch the home page URL", (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    private CloudFoundryApplicationModule getSelectedCloudAppModule() {
        CloudFoundryServer cloudServer = (CloudFoundryServer)this.selectedServer.loadAdapter(CloudFoundryServer.class, null);
        return cloudServer.getExistingCloudModule(this.selectedModule);
    }
}

