/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class CloudFoundryDebugSourceLocator
implements ISourcePathComputer {
    public CloudFoundryDebugSourceLocator() {
        this.init();
    }

    protected void init() {
    }

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String projectName;
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>();
        IRuntimeClasspathEntry jreEntry = JavaRuntime.computeJREEntry((ILaunchConfiguration)configuration);
        if (jreEntry != null) {
            entries.add(jreEntry);
        }
        if ((projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "")) == null) {
            return null;
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null && javaProject.isOpen() && ("".equals(projectName) || projectName.equals(javaProject.getElementName()))) {
                entries.add(JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)javaProject));
            }
            ++n2;
        }
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries.toArray(new IRuntimeClasspathEntry[entries.size()]), (ILaunchConfiguration)configuration);
        return JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
    }

    public String getId() {
        return "org.eclipse.cft.debug.sourcepathcomputer";
    }
}

