/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client.v2;

import java.util.Map;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.util.CloudUtil;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.eclipse.cft.server.core.internal.client.v2.RestUtils;
import org.eclipse.cft.server.core.internal.ssh.SshHost;
import org.springframework.web.client.RestTemplate;

public class CloudInfoV2 {
    private RestTemplate restTemplate;
    private String ccUrl;
    private Map<String, Object> infoV2Map;

    public CloudInfoV2(CloudCredentials creds, String url, HttpProxyConfiguration proxyConf, boolean selfSigned) {
        this.restTemplate = RestUtils.createRestTemplate(proxyConf, selfSigned, false);
        this.ccUrl = url;
    }

    public String getSshClientId() {
        return this.getProp("app_ssh_oauth_client");
    }

    public String getAuthorizationUrl() {
        return this.getProp("authorization_endpoint");
    }

    public String getCloudControllerUrl() {
        return this.ccUrl;
    }

    public String getCloudControllerApiVersion() {
        return this.getProp("api_version");
    }

    public String getProp(String name) {
        Map<String, Object> map = this.getMap();
        if (map != null) {
            return (String)CloudUtil.parse(String.class, (Object)map.get(name));
        }
        return null;
    }

    private Map<String, Object> getMap() {
        if (this.infoV2Map == null) {
            String infoV2Json = (String)this.restTemplate.getForObject(this.getUrl("/v2/info"), String.class, new Object[0]);
            this.infoV2Map = JsonUtil.convertJsonToMap((String)infoV2Json);
        }
        return this.infoV2Map;
    }

    private String getUrl(String path) {
        return String.valueOf(this.ccUrl) + path;
    }

    public SshHost getSshHost() {
        String fingerPrint = this.getProp("app_ssh_host_key_fingerprint");
        String host = this.getProp("app_ssh_endpoint");
        int port = 22;
        if (host != null && host.contains(":")) {
            String[] pieces = host.split(":");
            host = pieces[0];
            port = Integer.parseInt(pieces[1]);
        }
        if (host != null || fingerPrint != null) {
            return new SshHost(host, port, fingerPrint);
        }
        return null;
    }
}

