/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.List;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.application.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugDelegate;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryProperties;
import org.eclipse.cft.server.core.internal.debug.DebugConnectionDescriptor;
import org.eclipse.cft.server.core.internal.ssh.SshClientSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class SshDebugLaunchConfigDelegate
extends CloudFoundryDebugDelegate {
    private static final String JAVA_OPTS = "JAVA_OPTS";
    public static final String LAUNCH_CONFIGURATION_ID = "org.eclipse.cft.debug.launchconfig.ssh";

    @Override
    public String getLaunchConfigurationTypeId() {
        return LAUNCH_CONFIGURATION_ID;
    }

    protected boolean containsDebugOption(EnvironmentVariable var) {
        return var != null && var.getValue() != null && JAVA_OPTS.equals(var.getVariable()) && (var.getValue().contains("-Xdebug") || var.getValue().contains("-Xrunjdwp"));
    }

    protected void setEnvironmentVariable(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int remoteDebugPort, IProgressMonitor monitor) throws CoreException {
        ApplicationDeploymentInfo info = appModule.getDeploymentInfo();
        List<EnvironmentVariable> vars = info.getEnvVariables();
        EnvironmentVariable javaOpts = this.getDebugEnvironment(info);
        IModule[] mod = new IModule[]{appModule.getLocalModule()};
        boolean restart = CloudFoundryProperties.isModuleStopped.testProperty(mod, cloudServer);
        if (!this.containsDebugOption(javaOpts)) {
            if (javaOpts == null) {
                javaOpts = new EnvironmentVariable();
                javaOpts.setVariable(JAVA_OPTS);
                vars.add(javaOpts);
            }
            String debugOpts = "-Xdebug -Xrunjdwp:server=y,transport=dt_socket,address=" + remoteDebugPort + ",suspend=n";
            javaOpts.setValue(debugOpts);
            cloudServer.getBehaviour().operations().environmentVariablesUpdate(appModule.getLocalModule(), appModule.getDeployedApplicationName(), vars).run(monitor);
            restart = true;
        }
        if (restart) {
            this.printToConsole(appModule, cloudServer, NLS.bind((String)Messages.SshDebugLaunchConfigDelegate_RESTARTING_APP, (Object)appModule.getDeployedApplicationName()), false);
            cloudServer.getBehaviour().operations().applicationDeployment(mod, ApplicationAction.START, false).run(monitor);
        }
    }

    protected DebugConnectionDescriptor getSshConnectionDescriptor(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance, int remoteDebugPort, IProgressMonitor monitor) throws CoreException {
        String url = cloudServer.getUrl();
        String userName = cloudServer.getUsername();
        String password = cloudServer.getPassword();
        boolean selfSigned = cloudServer.getSelfSignedCertificate();
        SshClientSupport ssh = SshClientSupport.create(CloudFoundryServerBehaviour.createExternalClientLogin(url, userName, password, selfSigned, monitor), new CloudCredentials(userName, password), null, selfSigned);
        try {
            this.printToConsole(appModule, cloudServer, NLS.bind((String)Messages.SshDebugLaunchConfigDelegate_CONNECTING_FOR_USER, (Object)appModule.getDeployedApplicationName()), false);
            Session session = ssh.connect(appModule.getApplication(), cloudServer, appInstance);
            this.printToConsole(appModule, cloudServer, NLS.bind((String)Messages.SshDebugLaunchConfigDelegate_CONNECTION_SUCCESSFUL, (Object)appModule.getDeployedApplicationName()), false);
            int localDebuggerPort = session.setPortForwardingL(0, "localhost", remoteDebugPort);
            this.printToConsole(appModule, cloudServer, NLS.bind((String)Messages.SshDebugLaunchConfigDelegate_PORT_FORWARDING_SUCCESSFUL, (Object)remoteDebugPort, (Object)localDebuggerPort), false);
            return new DebugConnectionDescriptor("localhost", localDebuggerPort);
        }
        catch (JSchException e) {
            throw CloudErrorUtil.asCoreException("SSH connection error " + e.getMessage(), e, false);
        }
    }

    protected EnvironmentVariable getDebugEnvironment(ApplicationDeploymentInfo info) {
        List<EnvironmentVariable> vars = info.getEnvVariables();
        for (EnvironmentVariable var : vars) {
            if (!JAVA_OPTS.equals(var.getVariable())) continue;
            return var;
        }
        return null;
    }

    @Override
    protected DebugConnectionDescriptor getDebugConnectionDescriptor(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance, int remoteDebugPort, IProgressMonitor monitor) throws CoreException {
        this.setEnvironmentVariable(appModule, cloudServer, remoteDebugPort, monitor);
        return this.getSshConnectionDescriptor(appModule, cloudServer, appInstance, remoteDebugPort, monitor);
    }

    @Override
    protected void printToConsole(CloudFoundryApplicationModule appModule, CloudFoundryServer server, String message, boolean error) {
        super.printToConsole(appModule, server, NLS.bind((String)Messages.Ssh_CONSOLE_MESSAGE, (Object)message), error);
    }
}

