/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public abstract class CloudFoundryDebugProvider {
    public abstract boolean isDebugSupported(CloudFoundryApplicationModule var1, CloudFoundryServer var2);

    public abstract String getLaunchConfigurationType(CloudFoundryApplicationModule var1, CloudFoundryServer var2);

    public String getLaunchLabel(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance) {
        StringBuilder idBuffer = new StringBuilder();
        idBuffer.append(cloudServer.getUrl());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getCloudFoundrySpace().getOrgName());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getCloudFoundrySpace().getSpaceName());
        idBuffer.append('-');
        idBuffer.append(appModule.getDeployedApplicationName());
        idBuffer.append('-');
        idBuffer.append(appInstance);
        return idBuffer.toString();
    }

    public String getApplicationDebugLaunchId(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance) {
        StringBuilder idBuffer = new StringBuilder();
        idBuffer.append(cloudServer.getUrl());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getUsername());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getCloudFoundrySpace().getOrgName());
        idBuffer.append('-');
        idBuffer.append(cloudServer.getCloudFoundrySpace().getSpaceName());
        idBuffer.append('-');
        idBuffer.append(appModule.getDeployedApplicationName());
        idBuffer.append('-');
        idBuffer.append(appInstance);
        return idBuffer.toString();
    }

    public ILaunchConfiguration getLaunchConfiguration(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance, int remoteDebugPort, IProgressMonitor monitor) throws CoreException {
        String launchLabel = this.getLaunchLabel(appModule, cloudServer, appInstance);
        String launchType = this.getLaunchConfigurationType(appModule, cloudServer);
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchType);
        if (launchConfigType != null) {
            IProject project = appModule.getLocalModule().getProject();
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigType.newInstance((IContainer)project, launchLabel);
            ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
            if (project != null && project.isAccessible()) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            }
            wc.setAttribute("cloudDebugServer", cloudServer.getServerId());
            wc.setAttribute("cloudDebugAppName", appModule.getDeployedApplicationName());
            wc.setAttribute("cloudDebugAppInstance", appInstance);
            wc.setAttribute("cloudDebugRemoteDebugPort", remoteDebugPort);
            wc.setAttribute("cloudDebugAppLaunchId", this.getApplicationDebugLaunchId(appModule, cloudServer, appInstance));
            launchConfiguration = wc.doSave();
            return launchConfiguration;
        }
        throw CloudErrorUtil.toCoreException("No debug launch configuration found for - " + launchType);
    }
}

