/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui;

import org.eclipse.cft.server.core.AbstractAppStateTracker;
import org.eclipse.cft.server.core.ICloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.cft.server.ui.internal.console.ConsoleManagerRegistry;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public abstract class AbstractConsoleMonitorAppStateTracker
extends AbstractAppStateTracker {
    private ConsolePatternMatchListener consoleMonitor;

    protected ConsolePatternMatchListener createPatternMatchListener(IModule module) {
        return new ConsolePatternMatchListener(module.getName());
    }

    protected MessageConsole findCloudFoundryConsole(IServer server, IModule module) {
        CloudFoundryServer cfServer = (CloudFoundryServer)server.getAdapter(CloudFoundryServer.class);
        CloudFoundryApplicationModule appModule = cfServer.getExistingCloudModule(module);
        return ConsoleManagerRegistry.getConsoleManager(cfServer).findCloudFoundryConsole(server, appModule);
    }

    public int getApplicationState(ICloudFoundryApplicationModule appModule) {
        if (Logger.DETAILS) {
            Logger.println("/debug/details", (Object)this, "getApplicationState", "Waiting for app to start: " + appModule.getName() + ", state=" + this.consoleMonitor.getApplicationState());
        }
        return this.consoleMonitor.getApplicationState();
    }

    protected abstract String getAppStartedPattern();

    public void startTracking(IModule module) {
        if (this.server == null || module == null) {
            return;
        }
        MessageConsole console = this.findCloudFoundryConsole(this.server, module);
        if (console != null) {
            if (Logger.INFO) {
                Logger.println("/debug/info", (Object)this, "isApplicationStarted", "Start app state tracking: " + module.getName());
            }
            this.consoleMonitor = this.createPatternMatchListener(module);
            console.addPatternMatchListener((IPatternMatchListener)this.consoleMonitor);
        }
    }

    public void stopTracking(IModule module) {
        MessageConsole console;
        if (this.server == null || this.consoleMonitor == null || module == null) {
            return;
        }
        if (Logger.INFO) {
            Logger.println("/debug/info", (Object)this, "stopTracking", "Stop app state tracking: " + module.getName());
        }
        if ((console = this.findCloudFoundryConsole(this.server, module)) != null) {
            console.removePatternMatchListener((IPatternMatchListener)this.consoleMonitor);
        }
    }

    public class ConsolePatternMatchListener
    implements IPatternMatchListener {
        private String appName;
        private int appState = 1;

        public ConsolePatternMatchListener(String curAppName) {
            this.appName = curAppName;
        }

        public void connect(TextConsole console) {
        }

        public synchronized void disconnect() {
        }

        public void matchFound(PatternMatchEvent event) {
            if (Logger.INFO) {
                Logger.println("/debug/info", this, "matchFound", "Application start detected: " + this.appName);
            }
            this.appState = 2;
        }

        public String getPattern() {
            return AbstractConsoleMonitorAppStateTracker.this.getAppStartedPattern();
        }

        public int getCompilerFlags() {
            return 2;
        }

        public String getLineQualifier() {
            return "\\n|\\r";
        }

        protected int getApplicationState() {
            return this.appState;
        }
    }
}

