/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudSpacesDelegate;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.ServerWizardValidator;
import org.eclipse.cft.server.ui.internal.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class CredentialsWizardValidator
extends ServerWizardValidator {
    public CredentialsWizardValidator(CloudFoundryServer cloudServer, CloudSpacesDelegate cloudServerSpaceDelegate) {
        super(cloudServer, cloudServerSpaceDelegate);
    }

    @Override
    protected ValidationStatus validateLocally() {
        String userName = this.getCloudFoundryServer().getUsername();
        String password = this.getCloudFoundryServer().getPassword();
        String url = this.getCloudFoundryServer().getUrl();
        String message = null;
        boolean valuesFilled = false;
        int validationEventType = 1003;
        if (userName == null || userName.trim().length() == 0) {
            message = Messages.ENTER_AN_EMAIL;
        } else if (password == null || password.trim().length() == 0) {
            message = Messages.ENTER_A_PASSWORD;
        } else if (url == null || url.trim().length() == 0) {
            message = NLS.bind((String)Messages.SELECT_SERVER_URL, (Object)this.getSpaceDelegate().getServerServiceName());
        } else {
            valuesFilled = true;
            message = Messages.SERVER_WIZARD_VALIDATOR_CLICK_TO_VALIDATE;
        }
        int statusType = valuesFilled ? 0 : 1;
        IStatus status = CloudFoundryPlugin.getStatus((String)message, (int)statusType);
        return this.getValidationStatus(status, validationEventType);
    }
}

