/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.rse.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.rse.internal.CloudFoundryHostFile;
import org.eclipse.cft.server.rse.internal.FileResource;
import org.eclipse.cft.server.rse.internal.FilesContentProvider;
import org.eclipse.core.runtime.IProgressMonitor;

public class ApplicationResource
extends CloudFoundryHostFile {
    private CloudApplication app;
    private int id;
    private FilesContentProvider provider;
    private CloudFoundryServer server;
    private Map<String, List<FileResource>> fileMap;

    public ApplicationResource(CloudFoundryServer server, CloudApplication app, int id) {
        this.app = app;
        this.server = server;
        this.id = id;
        this.provider = new FilesContentProvider(server, app, id);
        this.fileMap = new HashMap<String, List<FileResource>>();
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public List<FileResource> fetchChildren(String path, IProgressMonitor monitor) {
        List<FileResource> files = this.provider.getElements(path, monitor);
        this.fileMap.put(path, files);
        return files;
    }

    public String getAbsolutePath() {
        return ApplicationResource.getAbsolutePath(this.app, String.valueOf(this.id));
    }

    public static String getAbsolutePath(CloudApplication app, String id) {
        StringBuilder builder = new StringBuilder();
        List uris = app.getUris();
        if (uris != null && !uris.isEmpty()) {
            builder.append((String)uris.get(0));
        } else {
            builder.append(app.getName());
        }
        builder.append("/");
        builder.append(id);
        return builder.toString();
    }

    public List<FileResource> getChildren(String path, IProgressMonitor monitor) {
        return this.fileMap.get(path);
    }

    @Override
    public String getClassification() {
        return "application";
    }

    public CloudApplication getCloudApplication() {
        return this.app;
    }

    public int getInstanceId() {
        return this.id;
    }

    public long getModifiedDate() {
        return 0L;
    }

    public String getName() {
        return String.valueOf(this.app.getName()) + "#" + this.id;
    }

    public String getParentPath() {
        return null;
    }

    public CloudFoundryServer getServer() {
        return this.server;
    }

    public long getSize() {
        return 0L;
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public void renameTo(String newAbsolutePath) {
    }
}

