/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.List;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.internal.application.FrameworkProvider;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDelegate;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDescriptor;
import org.eclipse.cft.server.ui.internal.wizards.IApplicationWizardDelegate;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class ApplicationWizardProvider {
    private final InternalApplicationWizardProvider internalProvider;
    private ApplicationWizardDelegate wizardDelegate;

    public ApplicationWizardProvider(IConfigurationElement configuration, String extensionPointID) {
        this.internalProvider = new InternalApplicationWizardProvider(configuration, extensionPointID);
    }

    public ApplicationWizardDelegate getDelegate(AbstractApplicationDelegate coreDelegate) {
        if (this.wizardDelegate == null) {
            IApplicationWizardDelegate actualDelegate = (IApplicationWizardDelegate)this.internalProvider.getDelegate();
            if (actualDelegate instanceof ApplicationWizardDelegate) {
                this.wizardDelegate = (ApplicationWizardDelegate)actualDelegate;
                this.wizardDelegate.setApplicationDelegate(coreDelegate);
            } else {
                this.wizardDelegate = new ApplicationWizardDelegateImp(actualDelegate, coreDelegate);
            }
        }
        return this.wizardDelegate;
    }

    public String getProviderID() {
        return this.internalProvider.getProviderID();
    }

    static class ApplicationWizardDelegateImp
    extends ApplicationWizardDelegate {
        private final IApplicationWizardDelegate actualDelegate;

        public ApplicationWizardDelegateImp(IApplicationWizardDelegate actualDelegate, AbstractApplicationDelegate coreDelegate) {
            this.actualDelegate = actualDelegate;
            this.setApplicationDelegate(coreDelegate);
        }

        @Override
        public List<IWizardPage> getWizardPages(ApplicationWizardDescriptor descriptor, IServer server, IModule module) {
            return this.actualDelegate.getWizardPages(descriptor, server, module);
        }
    }

    static class InternalApplicationWizardProvider
    extends FrameworkProvider<IApplicationWizardDelegate> {
        public InternalApplicationWizardProvider(IConfigurationElement configuration, String extensionPointID) {
            super(configuration, extensionPointID);
        }
    }
}

