/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.core.internal.application;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class StandaloneRuntimeResolver {
    public static final IPath[] TEST_SOURCE_NAME_PATTERNS = new IPath[]{new Path("src/test")};
    private final boolean skipTestSources;
    private final IJavaProject javaProject;
    private List<String> runtimeSource;
    private List<String> runtimeDependencies;

    public StandaloneRuntimeResolver(IJavaProject javaProject, boolean skipTestSources) {
        this.javaProject = javaProject;
        this.skipTestSources = skipTestSources;
    }

    protected boolean shouldSkipTestSources() {
        return this.skipTestSources;
    }

    protected Collection<IClasspathEntry> getSourceEntries(boolean istest) {
        try {
            IClasspathEntry[] rawEntries = this.javaProject.getRawClasspath();
            if (rawEntries != null) {
                HashSet<IClasspathEntry> sourceEntries = new HashSet<IClasspathEntry>();
                IClasspathEntry[] iClasspathEntryArray = rawEntries;
                int n = rawEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && (path = entry.getPath()) != null) {
                        boolean isTestSource = this.isTestSource(path.toOSString());
                        if (istest && isTestSource || !istest && !isTestSource) {
                            sourceEntries.add(entry);
                        }
                    }
                    ++n2;
                }
                return sourceEntries;
            }
        }
        catch (JavaModelException e) {
            CloudFoundryPlugin.log((CoreException)e);
        }
        return Collections.emptyList();
    }

    protected Collection<String> getSourceOutputLocations(boolean istest) {
        Collection<IClasspathEntry> entries = this.getSourceEntries(istest);
        HashSet<String> locations = new HashSet<String>();
        for (IClasspathEntry entry : entries) {
            IPath path = entry.getOutputLocation();
            if ((path = this.getWorkspaceFullPath(path)) == null) continue;
            locations.add(path.toOSString());
        }
        return locations;
    }

    protected Collection<String> getTestSourceOutputLocations() {
        return this.getSourceOutputLocations(true);
    }

    protected Collection<String> getNonTestSourceOutputLocations() {
        Collection<String> outputs = this.getSourceOutputLocations(false);
        HashSet<String> nonTestOutput = new HashSet<String>(outputs);
        try {
            IPath location = this.javaProject.getOutputLocation();
            location = this.getWorkspaceFullPath(location);
            if (location != null) {
                nonTestOutput.add(location.toOSString());
            }
        }
        catch (JavaModelException e) {
            CloudFoundryPlugin.log((CoreException)e);
        }
        return nonTestOutput;
    }

    protected IPath getWorkspaceFullPath(IPath relativePath) {
        if (relativePath == null) {
            return null;
        }
        IPath path = relativePath;
        if (path.segmentCount() == 1) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            if (project.isAccessible()) {
                path = project.getLocation();
            }
        } else {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            if (folder.isAccessible()) {
                path = folder.getLocation();
            }
        }
        return path;
    }

    protected boolean isTestSource(String location) {
        if (location != null) {
            IPath[] iPathArray = TEST_SOURCE_NAME_PATTERNS;
            int n = TEST_SOURCE_NAME_PATTERNS.length;
            int n2 = 0;
            while (n2 < n) {
                IPath testPattern = iPathArray[n2];
                if (location.contains(testPattern.toOSString())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public List<String> getRuntimeSourceLocations() throws CoreException {
        if (this.runtimeSource == null) {
            this.computeRuntimeClassPath();
        }
        return this.runtimeSource;
    }

    public List<String> getRuntimeDependencyLocations() throws CoreException {
        if (this.runtimeDependencies == null) {
            this.computeRuntimeClassPath();
        }
        return this.runtimeDependencies;
    }

    public boolean hasRuntimeDependencies() {
        try {
            return !this.getRuntimeDependencyLocations().isEmpty();
        }
        catch (CoreException e) {
            CloudFoundryPlugin.log((CoreException)e);
            return false;
        }
    }

    protected void computeRuntimeClassPath() throws CoreException {
        this.runtimeDependencies = new ArrayList<String>();
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)this.javaProject);
        IRuntimeClasspathEntry jreEntry = JavaRuntime.computeJREEntry((IJavaProject)this.javaProject);
        ArrayList<IRuntimeClasspathEntry> resolved = new ArrayList<IRuntimeClasspathEntry>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = unresolved;
        int n = unresolved.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry[] entries;
            IRuntimeClasspathEntry rcEntry = iRuntimeClasspathEntryArray[n2];
            if (!rcEntry.equals(jreEntry) && (entries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)rcEntry, (IJavaProject)this.javaProject)) != null) {
                resolved.addAll(Arrays.asList(entries));
            }
            ++n2;
        }
        ArrayList toSeparate = new ArrayList(resolved);
        for (IRuntimeClasspathEntry entry : resolved) {
            String entryLocation = entry.getLocation();
            if (!this.isAccessibleFile(entryLocation)) continue;
            toSeparate.remove(entry);
            this.runtimeDependencies.add(entry.getLocation());
        }
        resolved = toSeparate;
        if (this.shouldSkipTestSources()) {
            Collection<String> testSourceOutputLocations = this.getTestSourceOutputLocations();
            Collection<String> nonTestSourceOutputLocations = this.getNonTestSourceOutputLocations();
            ArrayList nonTestEntries = new ArrayList(resolved);
            for (IRuntimeClasspathEntry entry : resolved) {
                String entryLocation = entry.getLocation();
                if (!testSourceOutputLocations.contains(entryLocation) || nonTestSourceOutputLocations.contains(entryLocation)) continue;
                nonTestEntries.remove(entry);
            }
            resolved = nonTestEntries;
        }
        HashSet<String> resolvedEntryLocations = new HashSet<String>(resolved.size());
        for (IRuntimeClasspathEntry entry : resolved) {
            resolvedEntryLocations.add(entry.getLocation());
        }
        this.runtimeSource = new ArrayList<String>(resolvedEntryLocations);
    }

    protected boolean isAccessibleFile(String location) {
        File file = new File(location);
        try {
            return file.exists() && file.isFile();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

