/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CloudUrlDialog
extends Dialog {
    private String name;
    private String url;
    private Label messageLabel;
    private final List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allCloudUrls;

    public CloudUrlDialog(Shell parentShell, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allCloudUrls) {
        super(parentShell);
        this.allCloudUrls = allCloudUrls;
    }

    public CloudUrlDialog(Shell parentShell, String name, String url, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allCloudUrls) {
        super(parentShell);
        this.name = name;
        this.url = url;
        this.allCloudUrls = allCloudUrls;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.CloudUrlDialog_TEXT_CLOUD_URL);
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, -1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(2).applyTo(composite);
        this.messageLabel = new Label(composite, 0);
        this.messageLabel.setText(Messages.CloudUrlDialog_TEXT_ENTER_URL_LABEL);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.messageLabel);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.COMMONTXT_NAME_WITH_COLON);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)nameLabel);
        final Text nameText = new Text(composite, 2048);
        nameText.setEditable(true);
        if (this.name != null) {
            nameText.setText(this.name);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)nameText);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudUrlDialog.this.name = nameText.getText();
                CloudUrlDialog.this.update();
            }
        });
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Messages.COMMONTXT_URL);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)urlLabel);
        final Text urlText = new Text(composite, 2048);
        urlText.setEditable(true);
        if (this.url != null) {
            urlText.setText(this.url);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)urlText);
        urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudUrlDialog.this.url = urlText.getText();
                CloudUrlDialog.this.update();
            }
        });
        return super.createDialogArea(parent);
    }

    private void update() {
        boolean canFinish = false;
        if (this.name == null || this.name.length() == 0) {
            this.messageLabel.setText(Messages.CloudUrlDialog_TEXT_ENTER_URL_LABEL);
        } else if (this.url == null || this.url.length() == 0) {
            this.messageLabel.setText(Messages.CloudUrlDialog_TEXT_ENTER_URL);
        } else {
            canFinish = true;
            for (CloudFoundryBrandingExtensionPoint.CloudServerURL cloudUrl : this.allCloudUrls) {
                if (cloudUrl.getUrl().contains("{") || !cloudUrl.getName().equals(this.name)) continue;
                canFinish = false;
                this.messageLabel.setText(NLS.bind((String)Messages.CloudUrlDialog_TEXT_URL_EXISTS, (Object)this.name));
            }
            if (canFinish) {
                try {
                    URL urlObject = new URL(this.url);
                    String host = urlObject.getHost();
                    if (host == null || host.length() == 0) {
                        canFinish = false;
                        this.messageLabel.setText(Messages.COMMONTXT_ENTER_VALID_URL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    this.messageLabel.setText(Messages.COMMONTXT_ENTER_VALID_URL);
                    canFinish = false;
                }
                catch (CloudFoundryException cloudFoundryException) {
                    this.messageLabel.setText(Messages.CloudUrlDialog_TEXT_ENTER_VALID_CONTROLLER);
                    canFinish = false;
                }
                if (canFinish) {
                    this.messageLabel.setText(Messages.CloudUrlDialog_TEXT_CREATE_NEW_URL);
                }
            }
        }
        this.getButton(0).setEnabled(canFinish);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.update();
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    protected void okPressed() {
        final boolean[] shouldProceed = new boolean[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CloudFoundryPlugin.getCloudFoundryClientFactory().getCloudFoundryOperations(CloudUrlDialog.this.url).getCloudInfo();
                    shouldProceed[0] = true;
                }
                catch (Exception exception) {
                    shouldProceed[0] = MessageDialog.openQuestion((Shell)CloudUrlDialog.this.getParentShell(), (String)Messages.CloudUrlDialog_TEXT_INVALID_URL, (String)NLS.bind((String)Messages.CloudUrlDialog_TEXT_CONN_FAILED, (Object)CloudUrlDialog.this.url));
                }
            }
        });
        if (shouldProceed[0]) {
            super.okPressed();
        }
    }
}

