/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.rse.internal;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.rse.internal.ApplicationResource;
import org.eclipse.cft.server.rse.internal.CloudFoundryHostFile;
import org.eclipse.cft.server.rse.internal.CloudFoundryRsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AccountResource
extends CloudFoundryHostFile {
    private CloudFoundryServer server;
    private List<ApplicationResource> applications;

    public AccountResource(CloudFoundryServer server) {
        this.server = server;
        this.applications = new ArrayList<ApplicationResource>();
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public List<ApplicationResource> fetchChildren(IProgressMonitor monitor) {
        if (!this.applications.isEmpty()) {
            this.applications.clear();
        }
        try {
            List cloudApps = this.server.getBehaviour().getApplications(monitor);
            for (CloudApplication cloudApp : cloudApps) {
                int count = cloudApp.getInstances();
                int i = 0;
                while (i < count) {
                    ApplicationResource resource = new ApplicationResource(this.server, cloudApp, i);
                    this.applications.add(resource);
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            CloudFoundryRsePlugin.logError((String)"An error occurred while retrieving applications.", (Throwable)e);
        }
        return this.applications;
    }

    public String getAbsolutePath() {
        return String.valueOf(this.server.getServer().getName()) + "@" + this.server.getUrl();
    }

    public List<ApplicationResource> getChildren(IProgressMonitor monitor) {
        return this.applications;
    }

    @Override
    public String getClassification() {
        return "account";
    }

    public long getModifiedDate() {
        return 0L;
    }

    public String getName() {
        return this.server.getServer().getName();
    }

    public String getParentPath() {
        return null;
    }

    public CloudFoundryServer getServer() {
        return this.server;
    }

    public long getSize() {
        return 0L;
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isRoot() {
        return true;
    }

    public void renameTo(String newAbsolutePath) {
    }
}

