/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.client.v2.internal;

import org.eclipse.cft.server.client.v2.internal.V2Client;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.ProviderPriority;
import org.eclipse.cft.server.core.internal.client.CFClient;
import org.eclipse.cft.server.core.internal.client.CFClientProvider;
import org.eclipse.cft.server.core.internal.client.CFCloudCredentials;
import org.eclipse.cft.server.core.internal.client.CloudInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.osgi.framework.Version;

public class V2CFClientProvider
implements CFClientProvider {
    public ProviderPriority getPriority() {
        return ProviderPriority.LOW;
    }

    public boolean supports(String serverUrl, CloudInfo info) {
        return info != null && info.getDopplerUrl() != null && this.supportsVersion(info.getCCApiVersion());
    }

    public CFClient getClient(IServer cloudServer, CFCloudCredentials credentials, String orgName, String spaceName, IProgressMonitor monitor) throws CoreException {
        if (credentials.isPasscodeSet()) {
            throw CloudErrorUtil.toCoreException((String)"One-time passcode not supported in this version of v2 client for doppler log streaming.");
        }
        CloudFoundryServer cfServer = CloudServerUtil.getCloudServer((IServer)cloudServer);
        if (cfServer != null) {
            return new V2Client(cfServer, credentials, orgName, spaceName);
        }
        return null;
    }

    protected boolean supportsVersion(Version ccApiVersion) {
        if (ccApiVersion == null) {
            return false;
        }
        Version supported = this.getSupportedV2ClientApiVersion();
        return ccApiVersion.compareTo(supported) > 0;
    }

    public Version getSupportedV2ClientApiVersion() {
        return new Version("2.54.0");
    }
}

