/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.HealthCheckType;
import org.cloudfoundry.client.lib.domain.Staging;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.StringUtils;
import org.eclipse.cft.server.core.internal.application.ManifestParser;
import org.eclipse.cft.server.core.internal.client.CFCallable;
import org.eclipse.cft.server.core.internal.client.CFConsumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class CFPropertiesUpdateFromManifest {
    private ApplicationDeploymentInfo wc;
    private List<ManifestUpdateCaller> consumers = new ArrayList<ManifestUpdateCaller>();
    private final ManifestParser parser;

    public CFPropertiesUpdateFromManifest(ManifestParser parser) {
        this.parser = parser;
    }

    protected ApplicationDeploymentInfo getManifestDeploymentInfo() throws CoreException {
        if (this.wc == null) {
            throw CloudErrorUtil.toCoreException("Manifest comparator has not been loaded. Please load the comparator.");
        }
        return this.wc;
    }

    public ApplicationDeploymentInfo load(IProgressMonitor monitor) throws CoreException {
        this.wc = this.parser.load(monitor);
        return this.wc;
    }

    public CFPropertiesUpdateFromManifest memory(int memory, CFConsumer<Integer> consumer) throws CoreException {
        int manifestVal;
        if (this.getManifestDeploymentInfo().hasProperty("memory") && (manifestVal = this.getManifestDeploymentInfo().getMemory()) != memory) {
            this.add("memory", manifestVal, Integer.valueOf(memory), consumer);
        }
        return this;
    }

    public CFPropertiesUpdateFromManifest instances(int instances, CFConsumer<Integer> consumer) throws CoreException {
        int manifestVal;
        if (this.getManifestDeploymentInfo().hasProperty("instances") && (manifestVal = this.getManifestDeploymentInfo().getInstances()) != instances) {
            this.add("instances", manifestVal, Integer.valueOf(instances), consumer);
        }
        return this;
    }

    public CFPropertiesUpdateFromManifest diskQuota(int diskQuota, CFConsumer<Integer> consumer) throws CoreException {
        int manifestVal;
        if (this.getManifestDeploymentInfo().hasProperty("disk_quota") && (manifestVal = this.getManifestDeploymentInfo().getDiskQuota().intValue()) != diskQuota) {
            this.add("disk_quota", manifestVal, Integer.valueOf(diskQuota), consumer);
        }
        return this;
    }

    public CFPropertiesUpdateFromManifest v1Staging(Staging cloudStaging, CFConsumer<Staging> consumer) throws CoreException {
        String currentHche = cloudStaging.getHealthCheckHttpEndpoint();
        HealthCheckType hct = cloudStaging.getHealthCheckType();
        String currentHct = hct != null ? hct.toString() : null;
        String currentStack = cloudStaging.getStack();
        int currentTimeout = cloudStaging.getHealthCheckTimeout() != null ? cloudStaging.getHealthCheckTimeout() : 0;
        String currentBuildpack = cloudStaging.getBuildpackUrl();
        String currentDetectedBuildpack = cloudStaging.getDetectedBuildpack();
        String currentCommand = cloudStaging.getCommand();
        Staging.StagingBuilder builder = Staging.builder().healthCheckTimeout(Integer.valueOf(currentTimeout)).buildpack(currentBuildpack).detectedBuildpack(currentDetectedBuildpack).command(currentCommand);
        HashMap<String, String> changedProps = new HashMap<String, String>();
        String manifestHche = this.getManifestDeploymentInfo().getHealthCheckHttpEndpoint();
        String manifestHct = this.getManifestDeploymentInfo().getHealthCheckType();
        String manifestStack = this.getManifestDeploymentInfo().getStack();
        if (this.getManifestDeploymentInfo().hasProperty("health-check-http-endpoint") && !this.equals(manifestHche, currentHche)) {
            builder.healthCheckHttpEndpoint(manifestHche);
            changedProps.put("health-check-http-endpoint", this.getComparisonMessage("health-check-http-endpoint", manifestHche, currentHche));
        }
        if (this.getManifestDeploymentInfo().hasProperty("health-check-type") && !this.equals(manifestHct, currentHct)) {
            builder.healthCheckType(HealthCheckType.from((String)manifestHct));
            changedProps.put("health-check-type", this.getComparisonMessage("health-check-type", manifestHct, currentHct));
        }
        if (this.getManifestDeploymentInfo().hasProperty("stack") && !this.equals(manifestStack, currentStack)) {
            builder.stack(manifestStack);
            changedProps.put("stack", this.getComparisonMessage("stack", manifestStack, currentStack));
        }
        if (!changedProps.isEmpty()) {
            StringBuilder propNames = new StringBuilder();
            StringBuilder messages = new StringBuilder();
            int size = changedProps.size();
            for (Map.Entry entry : changedProps.entrySet()) {
                propNames.append((String)entry.getKey());
                if (--size > 0) {
                    propNames.append(", ");
                }
                messages.append((String)entry.getValue());
            }
            this.add(propNames.toString(), (Object)messages.toString(), (Object)builder.build(), (CFConsumer)consumer);
        }
        return this;
    }

    private <T> void add(String propertyName, String comparisonMessage, T manifestValue, CFConsumer<T> consumer) {
        this.consumers.add(this.wrap(propertyName, comparisonMessage, manifestValue, consumer));
    }

    private <T> void add(String propertyName, T manifestValue, T cloudValue, CFConsumer<T> consumer) {
        this.consumers.add(this.wrap(propertyName, this.getComparisonMessage(propertyName, manifestValue, cloudValue), manifestValue, consumer));
    }

    public List<String> update(IProgressMonitor monitor) throws CoreException {
        ArrayList<String> changedProps = new ArrayList<String>();
        if (!this.consumers.isEmpty()) {
            if (!CloudFoundryPlugin.getCallback().question(Messages.CFPropertiesUpdateFromManifest_TITLE_QUESTION_CONFIRM_UPDATES, this.getMessageAllChangedProps(this.consumers))) {
                CloudFoundryPlugin.logWarning(NLS.bind((String)Messages.CFPropertiesUpdateFromManifest_UPDATES_CANCELED, (Object)this.getManifestDeploymentInfo().getDeploymentName()));
                return Collections.emptyList();
            }
            for (ManifestUpdateCaller cfCallable : this.consumers) {
                try {
                    cfCallable.call(monitor);
                    changedProps.add(cfCallable.getProperty());
                }
                catch (CoreException e) {
                    CloudFoundryPlugin.logError(e);
                }
            }
        }
        return changedProps;
    }

    private String getMessageAllChangedProps(List<ManifestUpdateCaller> changedProps) throws CoreException {
        String message = String.valueOf(NLS.bind((String)Messages.CFPropertiesUpdateFromManifest_CHANGES_DETECTED, (Object)this.getManifestDeploymentInfo().getDeploymentName())) + "\n\n";
        for (ManifestUpdateCaller consumer : changedProps) {
            String chldMsg = consumer.getMessage();
            if (StringUtils.isEmpty(chldMsg)) continue;
            message = String.valueOf(message) + chldMsg;
        }
        message = String.valueOf(message) + "\n" + Messages.CFPropertiesUpdateFromManifest_CONFIRM_UPDATES;
        return message;
    }

    protected <T> ManifestUpdateCaller wrap(final String property, String message, final T result, final CFConsumer<T> consumer) {
        return new ManifestUpdateCaller(property, message){

            @Override
            public void call(IProgressMonitor monitor) throws CoreException {
                try {
                    consumer.accept(result, monitor);
                }
                catch (Throwable e) {
                    String error = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
                    String message = NLS.bind((String)Messages.CFPropertiesUpdateFromManifest_ERROR_UPDATING_PROPERTY, (Object[])new String[]{property, CFPropertiesUpdateFromManifest.this.getManifestDeploymentInfo().getDeploymentName(), error});
                    throw CloudErrorUtil.toCoreException(message, e);
                }
            }
        };
    }

    protected boolean equals(String local, String cf) {
        if (local == null) {
            return cf == null;
        }
        return local.equals(cf);
    }

    protected <T> String getComparisonMessage(String property, T manifestValue, T cloudValue) {
        String message = String.valueOf(property) + " -- " + Messages.CFPropertiesUpdateFromManifest_MANIFEST_LABEL + ": " + manifestValue + ", " + Messages.CFPropertiesUpdateFromManifest_CLOUD_LABEL + ": " + cloudValue + '\n';
        return message;
    }

    public static abstract class ManifestUpdateCaller
    implements CFCallable {
        private final String property;
        private final String message;

        public ManifestUpdateCaller(String property, String message) {
            this.property = property;
            this.message = message;
        }

        public String getProperty() {
            return this.property;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

