/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.ModulesOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;

public abstract class AbstractPublishApplicationOperation
extends ModulesOperation {
    public static String INTERNAL_ERROR_NO_MAPPED_CLOUD_MODULE = "Internal Error: No cloud application module found for: {0} - Unable to deploy or start application";
    private final IModule[] modules;

    protected AbstractPublishApplicationOperation(CloudFoundryServerBehaviour behaviour, IModule[] modules) {
        super(behaviour, modules);
        this.modules = modules;
    }

    protected CloudFoundryApplicationModule getOrCreateCloudApplicationModule(IModule[] modules) throws CoreException {
        IModule module = modules[0];
        CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
        CloudFoundryApplicationModule appModule = cloudServer.getOrCreateCloudModule(module);
        if (appModule == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)INTERNAL_ERROR_NO_MAPPED_CLOUD_MODULE, (Object)modules[0].getId()));
        }
        return appModule;
    }

    @Override
    protected void runOnVerifiedModule(IProgressMonitor monitor) throws CoreException {
        try {
            this.doApplicationOperation(monitor);
            this.getBehaviour().asyncUpdateModuleAfterPublish(this.getFirstModule());
        }
        catch (OperationCanceledException e) {
            this.cancelPublish(e, monitor);
        }
        catch (Throwable e) {
            this.getBehaviour().getCloudFoundryServer().moduleAdditionCompleted(this.getFirstModule());
            this.getBehaviour().operations().updateModule(this.getFirstModule()).run(monitor);
            throw e;
        }
    }

    protected void cancelPublish(OperationCanceledException e, IProgressMonitor monitor) throws CoreException {
        CloudFoundryPlugin.logWarning(e.getMessage());
        CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
        CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(this.getFirstModule());
        if (appModule != null && e.getMessage() != null) {
            CloudFoundryPlugin.getCallback().printToConsole(cloudServer, appModule, String.valueOf(NLS.bind((String)Messages.AbstractPublishApplicationOperation_OPERATION_CANCELED, (Object)e.getMessage())) + '\n', false, false);
        }
        this.getBehaviour().getCloudFoundryServer().moduleAdditionCompleted(this.getFirstModule());
        this.onOperationCanceled(e, monitor);
        ((Server)this.getBehaviour().getServer()).setModuleState(this.getModules(), 0);
        ((Server)this.getBehaviour().getServer()).setServerPublishState(2);
        ((Server)this.getBehaviour().getServer()).setModulePublishState(this.modules, 2);
    }

    protected void onOperationCanceled(OperationCanceledException e, IProgressMonitor monitor) throws CoreException {
    }

    protected abstract void doApplicationOperation(IProgressMonitor var1) throws CoreException;
}

