/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.AbstractWaitWithProgressJob;
import org.eclipse.cft.server.core.internal.client.CFClient;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CFLoginHandler {
    private final CFClient client;
    private static final String DEFAULT_PROGRESS_LABEL = Messages.CloudFoundryLoginHandler_LABEL_PERFORM_CF_OPERATION;
    private static final int DEFAULT_PROGRESS_TICKS = 100;
    private CloudFoundryServer server;

    public CFLoginHandler(CFClient client, CloudFoundryServer server) {
        this.client = client;
        this.server = server;
    }

    public String login(IProgressMonitor monitor) throws CoreException {
        return this.login(monitor, 1, 0L);
    }

    public String login(IProgressMonitor monitor, int tries, long sleep) throws CoreException {
        return this.internalLogin(monitor, tries, sleep);
    }

    protected String internalLogin(IProgressMonitor monitor, int tries, long sleep) throws CoreException {
        return (String)new AbstractWaitWithProgressJob<String>(tries, sleep){

            @Override
            protected String runInWait(IProgressMonitor monitor) throws CoreException {
                String tokenValue = CFLoginHandler.this.client.login();
                if (CFLoginHandler.this.server != null) {
                    CFLoginHandler.this.server.setAndSaveToken(tokenValue);
                }
                return tokenValue;
            }

            @Override
            protected boolean shouldRetryOnError(Throwable t) {
                return CFLoginHandler.this.shouldAttemptClientLogin(t);
            }
        }.run(monitor);
    }

    protected SubMonitor getProgressMonitor(IProgressMonitor progressMonitor) {
        return progressMonitor instanceof SubMonitor ? (SubMonitor)progressMonitor : SubMonitor.convert((IProgressMonitor)progressMonitor, (String)DEFAULT_PROGRESS_LABEL, (int)100);
    }

    public boolean shouldAttemptClientLogin(Throwable t) {
        return CloudErrorUtil.getInvalidCredentialsError(t) != null;
    }
}

