/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=ur

/**
 * Localized names for the "ur" locale.
 */
public class LocalizedNamesImpl_ur extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PK",
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "IE",
        "IS",
        "IM",
        "AZ",
        "AM",
        "AT",
        "AU",
        "AX",
        "AR",
        "JO",
        "AW",
        "ER",
        "UZ",
        "GQ",
        "IL",
        "EE",
        "AC",
        "AF",
        "AL",
        "DZ",
        "SV",
        "UM",
        "AS",
        "VI",
        "AQ",
        "AG",
        "AD",
        "ID",
        "AI",
        "AO",
        "IT",
        "ET",
        "IR",
        "EC",
        "BV",
        "BB",
        "BH",
        "BR",
        "IO",
        "BM",
        "BN",
        "BI",
        "VG",
        "BF",
        "BG",
        "BD",
        "BW",
        "BA",
        "BO",
        "IN",
        "BT",
        "BS",
        "QO",
        "BZ",
        "BY",
        "BE",
        "BJ",
        "TW",
        "TJ",
        "TC",
        "TM",
        "TR",
        "TT",
        "TZ",
        "TH",
        "TL",
        "TN",
        "GE",
        "JP",
        "GI",
        "DJ",
        "JE",
        "DE",
        "JM",
        "ZA",
        "GS",
        "SS",
        "KR",
        "RW",
        "RU",
        "RO",
        "US",
        "RE",
        "ZM",
        "ZW",
        "ST",
        "WS",
        "SM",
        "RS",
        "LK",
        "SC",
        "SA",
        "GB",
        "SK",
        "SI",
        "SX",
        "SG",
        "CH",
        "SZ",
        "SJ",
        "SR",
        "SB",
        "SD",
        "SE",
        "SL",
        "EA",
        "BL",
        "LC",
        "MF",
        "VC",
        "PM",
        "KN",
        "SH",
        "SN",
        "SY",
        "MP",
        "KP",
        "SO",
        "IQ",
        "OM",
        "GD",
        "FK",
        "FJ",
        "FR",
        "TF",
        "PF",
        "FO",
        "GF",
        "PS",
        "PH",
        "FI",
        "CY",
        "KZ",
        "QA",
        "LA",
        "LR",
        "LB",
        "LT",
        "LV",
        "LU",
        "LY",
        "LS",
        "LI",
        "FM",
        "MH",
        "MQ",
        "MU",
        "MD",
        "MV",
        "MT",
        "ML",
        "YT",
        "AE",
        "MA",
        "EG",
        "EH",
        "MK",
        "MW",
        "MY",
        "MN",
        "MR",
        "MZ",
        "MC",
        "MS",
        "ME",
        "MG",
        "MO",
        "MM",
        "MX",
        "NR",
        "NE",
        "NG",
        "NF",
        "NO",
        "NA",
        "NI",
        "NU",
        "NL",
        "AN",
        "NZ",
        "NC",
        "NP",
        "VA",
        "CF",
        "VN",
        "WF",
        "VE",
        "VU",
        "TA",
        "TO",
        "TV",
        "TK",
        "TG",
        "PG",
        "PK",
        "PT",
        "PW",
        "PA",
        "PL",
        "PN",
        "PY",
        "PE",
        "PR",
        "TD",
        "CL",
        "CN",
        "CZ",
        "DG",
        "DK",
        "DM",
        "DO",
        "CG",
        "CD",
        "CX",
        "KG",
        "HR",
        "KI",
        "BQ",
        "CP",
        "KH",
        "XK",
        "CR",
        "CO",
        "KM",
        "CI",
        "CC",
        "KW",
        "CK",
        "CM",
        "KY",
        "IC",
        "KE",
        "CA",
        "CU",
        "CW",
        "CV",
        "GM",
        "GL",
        "GN",
        "GW",
        "GU",
        "GG",
        "GT",
        "GP",
        "GH",
        "GY",
        "GA",
        "HK",
        "ES",
        "HU",
        "HN",
        "HM",
        "HT",
        "YE",
        "EU",
        "UY",
        "GR",
        "UA",
        "UG",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "دنیا");
    namesMap.put("002", "افریقہ");
    namesMap.put("003", "شمالی امریکہ");
    namesMap.put("005", "جنوبی امریکہ");
    namesMap.put("009", "اوشیانیا");
    namesMap.put("011", "مغربی افریقہ");
    namesMap.put("013", "وسطی امریکہ");
    namesMap.put("014", "مشرقی افریقہ");
    namesMap.put("015", "شمالی افریقہ");
    namesMap.put("017", "وسطی افریقہ");
    namesMap.put("018", "جنوبی افریقہ کے علاقہ");
    namesMap.put("019", "امیریکاز");
    namesMap.put("021", "شمالی امریکہ کا علاقہ");
    namesMap.put("029", "کریبیائی");
    namesMap.put("030", "مشرقی ایشیا");
    namesMap.put("034", "جنوبی ایشیا");
    namesMap.put("035", "جنوب مشرقی ایشیا");
    namesMap.put("039", "جنوبی یورپ");
    namesMap.put("053", "آسٹریلیشیا");
    namesMap.put("054", "مالینیشیا");
    namesMap.put("057", "مائکرونیشیائی علاقہ");
    namesMap.put("061", "پولینیشیا");
    namesMap.put("142", "ایشیا");
    namesMap.put("143", "وسطی ایشیا");
    namesMap.put("145", "مغربی ایشیا");
    namesMap.put("150", "یوروپ");
    namesMap.put("151", "مشرقی یورپ");
    namesMap.put("154", "شمالی یورپ");
    namesMap.put("155", "مغربی یورپ");
    namesMap.put("419", "لاطینی امریکہ");
    namesMap.put("AC", "اسکینسیئن آئلینڈ");
    namesMap.put("AD", "انڈورا");
    namesMap.put("AE", "متحدہ عرب امارات");
    namesMap.put("AF", "افغانستان");
    namesMap.put("AG", "انٹیگوا اور باربودا");
    namesMap.put("AI", "انگوئیلا");
    namesMap.put("AL", "البانیہ");
    namesMap.put("AM", "آرمینیا");
    namesMap.put("AN", "نیدرلینڈز انٹیلیز");
    namesMap.put("AO", "انگولا");
    namesMap.put("AQ", "انٹارکٹیکا");
    namesMap.put("AR", "ارجنٹینا");
    namesMap.put("AS", "امریکی ساموآ");
    namesMap.put("AT", "آسٹریا");
    namesMap.put("AU", "آسٹریلیا");
    namesMap.put("AW", "اروبا");
    namesMap.put("AX", "آلینڈ آئلینڈز");
    namesMap.put("AZ", "آذربائجان");
    namesMap.put("BA", "بوسنیا اور ہرزیگووینا");
    namesMap.put("BB", "باربادوس");
    namesMap.put("BD", "بنگلہ دیش");
    namesMap.put("BE", "بیلجیم");
    namesMap.put("BF", "برکینا فاسو");
    namesMap.put("BG", "بلغاریہ");
    namesMap.put("BH", "بحرین");
    namesMap.put("BI", "برونڈی");
    namesMap.put("BJ", "بینن");
    namesMap.put("BL", "سینٹ برتھلیمی");
    namesMap.put("BM", "برمودا");
    namesMap.put("BN", "برونئی");
    namesMap.put("BO", "بولیویا");
    namesMap.put("BQ", "کریبیائی نیدرلینڈز");
    namesMap.put("BR", "برازیلی");
    namesMap.put("BS", "بہاماس");
    namesMap.put("BT", "بھوٹان");
    namesMap.put("BV", "بؤویٹ آئلینڈ");
    namesMap.put("BW", "بوتسوانا");
    namesMap.put("BY", "بیلاروس");
    namesMap.put("BZ", "بیلائز");
    namesMap.put("CA", "کینیڈا");
    namesMap.put("CC", "کوکوس (کیلنگ) جزائر");
    namesMap.put("CD", "کانگو - کنشاسا");
    namesMap.put("CF", "وسط افریقی جمہوریہ");
    namesMap.put("CG", "کانگو - برازاویلے");
    namesMap.put("CH", "سوئٹزر لینڈ");
    namesMap.put("CI", "کوٹ ڈی آئیوری");
    namesMap.put("CK", "کک آئلینڈز");
    namesMap.put("CL", "چلی");
    namesMap.put("CM", "کیمرون");
    namesMap.put("CN", "چین");
    namesMap.put("CO", "کولمبیا");
    namesMap.put("CP", "کلپّرٹن آئلینڈ");
    namesMap.put("CR", "کوسٹا ریکا");
    namesMap.put("CU", "کیوبا");
    namesMap.put("CV", "کیپ ورڈی");
    namesMap.put("CW", "کیوراکاؤ");
    namesMap.put("CX", "کرسمس آئلینڈ");
    namesMap.put("CY", "قبرص");
    namesMap.put("CZ", "چیک جمہوریہ");
    namesMap.put("DE", "جرمنی");
    namesMap.put("DG", "ڈائجو گارسیا");
    namesMap.put("DJ", "جبوتی");
    namesMap.put("DK", "ڈنمارک");
    namesMap.put("DM", "ڈومنیکا");
    namesMap.put("DO", "ڈومنیکن جمہوریہ");
    namesMap.put("DZ", "الجیریا");
    namesMap.put("EA", "سیئوٹا اور میلیلا");
    namesMap.put("EC", "ایکواڈور");
    namesMap.put("EE", "اسٹونیا");
    namesMap.put("EG", "مصر");
    namesMap.put("EH", "مغربی صحارا");
    namesMap.put("ER", "اریٹیریا");
    namesMap.put("ES", "ہسپانیہ");
    namesMap.put("ET", "ایتھوپیا");
    namesMap.put("EU", "یوروپی یونین");
    namesMap.put("FI", "فن لینڈ");
    namesMap.put("FJ", "فجی");
    namesMap.put("FK", "فاکلینڈ جزائر");
    namesMap.put("FM", "مائکرونیشیا");
    namesMap.put("FO", "فروئی آئلینڈز");
    namesMap.put("FR", "فرانس");
    namesMap.put("GA", "گیبون");
    namesMap.put("GB", "سلطنت متحدہ");
    namesMap.put("GD", "غرناطہ");
    namesMap.put("GE", "جارجیا");
    namesMap.put("GF", "فرینچ گیانا");
    namesMap.put("GG", "گوئرنسی");
    namesMap.put("GH", "گھانا");
    namesMap.put("GI", "جبل الطارق");
    namesMap.put("GL", "گرین لینڈ");
    namesMap.put("GM", "گامبیا");
    namesMap.put("GN", "گنی");
    namesMap.put("GP", "گواڈیلوپ");
    namesMap.put("GQ", "استوائی گیانا");
    namesMap.put("GR", "یونان");
    namesMap.put("GS", "جنوبی جارجیا اور جنوبی سینڈوچ جزائر");
    namesMap.put("GT", "گواٹے مالا");
    namesMap.put("GU", "گوآم");
    namesMap.put("GW", "گنی بساؤ");
    namesMap.put("GY", "گیانا");
    namesMap.put("HK", "ہانگ کانگ SAR چین");
    namesMap.put("HM", "ہیئرڈ آئلینڈ اور میکڈونالڈ آئلینڈز");
    namesMap.put("HN", "ہونڈاروس");
    namesMap.put("HR", "کروشیا");
    namesMap.put("HT", "ہیتی");
    namesMap.put("HU", "ہنگری");
    namesMap.put("IC", "کینری آئلینڈز");
    namesMap.put("ID", "انڈونیشیا");
    namesMap.put("IE", "آئرلینڈ");
    namesMap.put("IL", "اسرائیل");
    namesMap.put("IM", "آئل آف مین");
    namesMap.put("IN", "بھارت");
    namesMap.put("IO", "برطانوی ہندوستانی سمندری خطہ");
    namesMap.put("IQ", "عراق");
    namesMap.put("IR", "ایران");
    namesMap.put("IS", "آئس لینڈ");
    namesMap.put("IT", "اٹلی");
    namesMap.put("JE", "جرسی");
    namesMap.put("JM", "جمائیکا");
    namesMap.put("JO", "اردن");
    namesMap.put("JP", "جاپان");
    namesMap.put("KE", "کینیا");
    namesMap.put("KG", "کرغزستان");
    namesMap.put("KH", "کمبوڈیا");
    namesMap.put("KI", "کریباتی");
    namesMap.put("KM", "کوموروس");
    namesMap.put("KN", "سینٹ کٹس اور نیویس");
    namesMap.put("KP", "شمالی کوریا");
    namesMap.put("KR", "جنوبی کوریا");
    namesMap.put("KW", "کویت");
    namesMap.put("KY", "کیمین آئلینڈز");
    namesMap.put("KZ", "قزاخستان");
    namesMap.put("LA", "لاؤس");
    namesMap.put("LB", "لبنان");
    namesMap.put("LC", "سینٹ لوسیا");
    namesMap.put("LI", "لیشٹنسٹائن");
    namesMap.put("LK", "سری لنکا");
    namesMap.put("LR", "لائبیریا");
    namesMap.put("LS", "لیسوتھو");
    namesMap.put("LT", "لتھوانیا");
    namesMap.put("LU", "لگژمبرگ");
    namesMap.put("LV", "لٹویا");
    namesMap.put("LY", "لیبیا");
    namesMap.put("MA", "مراقش");
    namesMap.put("MC", "موناکو");
    namesMap.put("MD", "مالدووا");
    namesMap.put("ME", "مونٹے نیگرو");
    namesMap.put("MF", "سینٹ مارٹن");
    namesMap.put("MG", "مڈغاسکر");
    namesMap.put("MH", "مارشل آئلینڈز");
    namesMap.put("MK", "مقدونیہ");
    namesMap.put("ML", "مالی");
    namesMap.put("MM", "میانمار (برما)");
    namesMap.put("MN", "منگولیا");
    namesMap.put("MO", "مکاؤ SAR چین");
    namesMap.put("MP", "شمالی ماریانا آئلینڈز");
    namesMap.put("MQ", "مارٹینک");
    namesMap.put("MR", "موریطانیہ");
    namesMap.put("MS", "مونٹسیراٹ");
    namesMap.put("MT", "مالٹا");
    namesMap.put("MU", "ماریشس");
    namesMap.put("MV", "مالدیو");
    namesMap.put("MW", "ملاوی");
    namesMap.put("MX", "میکسیکو");
    namesMap.put("MY", "ملیشیا");
    namesMap.put("MZ", "موزمبیق");
    namesMap.put("NA", "نامیبیا");
    namesMap.put("NC", "نیو کلیڈونیا");
    namesMap.put("NE", "نائجر");
    namesMap.put("NF", "نار فاک آئلینڈ");
    namesMap.put("NG", "نائجیریا");
    namesMap.put("NI", "نکاراگووا");
    namesMap.put("NL", "نیدر لینڈز");
    namesMap.put("NO", "ناروے");
    namesMap.put("NP", "نیپال");
    namesMap.put("NR", "نؤرو");
    namesMap.put("NU", "نیئو");
    namesMap.put("NZ", "نیوزی ینڈ");
    namesMap.put("OM", "عمان");
    namesMap.put("PA", "پنامہ");
    namesMap.put("PE", "پیرو");
    namesMap.put("PF", "فرانسیسی پولینیشیا");
    namesMap.put("PG", "پاپوآ نیو گنی");
    namesMap.put("PH", "فلپائنی");
    namesMap.put("PK", "پاکستان");
    namesMap.put("PL", "پولینڈ");
    namesMap.put("PM", "سینٹ پیئر اور میکلیئون");
    namesMap.put("PN", "پٹکائرن جزائر");
    namesMap.put("PR", "پیورٹو ریکو");
    namesMap.put("PS", "فلسطینی خطے");
    namesMap.put("PT", "پرتگال");
    namesMap.put("PW", "پلاؤ");
    namesMap.put("PY", "پیراگوئے");
    namesMap.put("QA", "قطر");
    namesMap.put("QO", "بیرونی اوشیانیا");
    namesMap.put("RE", "ری یونین");
    namesMap.put("RO", "رومانیا");
    namesMap.put("RS", "سربیا");
    namesMap.put("RU", "روسی");
    namesMap.put("RW", "روانڈا");
    namesMap.put("SA", "سعودی عرب");
    namesMap.put("SB", "سولومن آئلینڈز");
    namesMap.put("SC", "سشلیز");
    namesMap.put("SD", "سوڈان");
    namesMap.put("SE", "سویڈن");
    namesMap.put("SG", "سنگاپور");
    namesMap.put("SH", "سینٹ ہیلینا");
    namesMap.put("SI", "سلووینیا");
    namesMap.put("SJ", "سوالبرڈ اور جان ماین");
    namesMap.put("SK", "سلوواکیہ");
    namesMap.put("SL", "سیئر لیون");
    namesMap.put("SM", "سان مارینو");
    namesMap.put("SN", "سینیگل");
    namesMap.put("SO", "صومالیہ");
    namesMap.put("SR", "سورینام");
    namesMap.put("SS", "جنوبی سوڈان");
    namesMap.put("ST", "ساؤ ٹوم اور پرنسپے");
    namesMap.put("SV", "ال سلواڈور");
    namesMap.put("SX", "سنٹ مارٹن");
    namesMap.put("SY", "شام");
    namesMap.put("SZ", "سوازی لینڈ");
    namesMap.put("TA", "ٹرسٹن ڈا کیونہا");
    namesMap.put("TC", "ترکس اور کیکاؤس جزائر");
    namesMap.put("TD", "چاڈ");
    namesMap.put("TF", "فرانسیسی جنوبی خطے");
    namesMap.put("TG", "ٹوگو");
    namesMap.put("TH", "تھائی لینڈ");
    namesMap.put("TJ", "تاجکستان");
    namesMap.put("TK", "ٹوکیلاؤ");
    namesMap.put("TL", "تیمور لیسٹ");
    namesMap.put("TM", "ترکمانستان");
    namesMap.put("TN", "تیونیسیا");
    namesMap.put("TO", "ٹونگا");
    namesMap.put("TR", "ترکی");
    namesMap.put("TT", "ترینیداد اور ٹوباگو");
    namesMap.put("TV", "ٹووالو");
    namesMap.put("TW", "تائیوان");
    namesMap.put("TZ", "تنزانیہ");
    namesMap.put("UA", "یوکرین");
    namesMap.put("UG", "یوگانڈا");
    namesMap.put("UM", "امریکہ سے باہر کے چھوٹے جزائز");
    namesMap.put("US", "ریاستہائے متحدہ");
    namesMap.put("UY", "یوروگوئے");
    namesMap.put("UZ", "ازبکستان");
    namesMap.put("VA", "واٹیکن سٹی");
    namesMap.put("VC", "سینٹ ونسنٹ اور گرینیڈائنز");
    namesMap.put("VE", "وینزوئیلا");
    namesMap.put("VG", "برٹش ورجن آئلینڈز");
    namesMap.put("VI", "امریکی ورجن آئلینڈز");
    namesMap.put("VN", "ویتنام");
    namesMap.put("VU", "وینوآٹو");
    namesMap.put("WF", "ویلیز اور فیوٹیونا");
    namesMap.put("WS", "ساموآ");
    namesMap.put("XK", "کوسووو");
    namesMap.put("YE", "یمن");
    namesMap.put("YT", "مایوٹ");
    namesMap.put("ZA", "جنوبی افریقہ");
    namesMap.put("ZM", "زامبیا");
    namesMap.put("ZW", "زمبابوے");
    namesMap.put("ZZ", "نامعلوم علاقہ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "دنیا",
        "002": "افریقہ",
        "003": "شمالی امریکہ",
        "005": "جنوبی امریکہ",
        "009": "اوشیانیا",
        "011": "مغربی افریقہ",
        "013": "وسطی امریکہ",
        "014": "مشرقی افریقہ",
        "015": "شمالی افریقہ",
        "017": "وسطی افریقہ",
        "018": "جنوبی افریقہ کے علاقہ",
        "019": "امیریکاز",
        "021": "شمالی امریکہ کا علاقہ",
        "029": "کریبیائی",
        "030": "مشرقی ایشیا",
        "034": "جنوبی ایشیا",
        "035": "جنوب مشرقی ایشیا",
        "039": "جنوبی یورپ",
        "053": "آسٹریلیشیا",
        "054": "مالینیشیا",
        "057": "مائکرونیشیائی علاقہ",
        "061": "پولینیشیا",
        "142": "ایشیا",
        "143": "وسطی ایشیا",
        "145": "مغربی ایشیا",
        "150": "یوروپ",
        "151": "مشرقی یورپ",
        "154": "شمالی یورپ",
        "155": "مغربی یورپ",
        "419": "لاطینی امریکہ",
        "AC": "اسکینسیئن آئلینڈ",
        "AD": "انڈورا",
        "AE": "متحدہ عرب امارات",
        "AF": "افغانستان",
        "AG": "انٹیگوا اور باربودا",
        "AI": "انگوئیلا",
        "AL": "البانیہ",
        "AM": "آرمینیا",
        "AN": "نیدرلینڈز انٹیلیز",
        "AO": "انگولا",
        "AQ": "انٹارکٹیکا",
        "AR": "ارجنٹینا",
        "AS": "امریکی ساموآ",
        "AT": "آسٹریا",
        "AU": "آسٹریلیا",
        "AW": "اروبا",
        "AX": "آلینڈ آئلینڈز",
        "AZ": "آذربائجان",
        "BA": "بوسنیا اور ہرزیگووینا",
        "BB": "باربادوس",
        "BD": "بنگلہ دیش",
        "BE": "بیلجیم",
        "BF": "برکینا فاسو",
        "BG": "بلغاریہ",
        "BH": "بحرین",
        "BI": "برونڈی",
        "BJ": "بینن",
        "BL": "سینٹ برتھلیمی",
        "BM": "برمودا",
        "BN": "برونئی",
        "BO": "بولیویا",
        "BQ": "کریبیائی نیدرلینڈز",
        "BR": "برازیلی",
        "BS": "بہاماس",
        "BT": "بھوٹان",
        "BV": "بؤویٹ آئلینڈ",
        "BW": "بوتسوانا",
        "BY": "بیلاروس",
        "BZ": "بیلائز",
        "CA": "کینیڈا",
        "CC": "کوکوس (کیلنگ) جزائر",
        "CD": "کانگو - کنشاسا",
        "CF": "وسط افریقی جمہوریہ",
        "CG": "کانگو - برازاویلے",
        "CH": "سوئٹزر لینڈ",
        "CI": "کوٹ ڈی آئیوری",
        "CK": "کک آئلینڈز",
        "CL": "چلی",
        "CM": "کیمرون",
        "CN": "چین",
        "CO": "کولمبیا",
        "CP": "کلپّرٹن آئلینڈ",
        "CR": "کوسٹا ریکا",
        "CU": "کیوبا",
        "CV": "کیپ ورڈی",
        "CW": "کیوراکاؤ",
        "CX": "کرسمس آئلینڈ",
        "CY": "قبرص",
        "CZ": "چیک جمہوریہ",
        "DE": "جرمنی",
        "DG": "ڈائجو گارسیا",
        "DJ": "جبوتی",
        "DK": "ڈنمارک",
        "DM": "ڈومنیکا",
        "DO": "ڈومنیکن جمہوریہ",
        "DZ": "الجیریا",
        "EA": "سیئوٹا اور میلیلا",
        "EC": "ایکواڈور",
        "EE": "اسٹونیا",
        "EG": "مصر",
        "EH": "مغربی صحارا",
        "ER": "اریٹیریا",
        "ES": "ہسپانیہ",
        "ET": "ایتھوپیا",
        "EU": "یوروپی یونین",
        "FI": "فن لینڈ",
        "FJ": "فجی",
        "FK": "فاکلینڈ جزائر",
        "FM": "مائکرونیشیا",
        "FO": "فروئی آئلینڈز",
        "FR": "فرانس",
        "GA": "گیبون",
        "GB": "سلطنت متحدہ",
        "GD": "غرناطہ",
        "GE": "جارجیا",
        "GF": "فرینچ گیانا",
        "GG": "گوئرنسی",
        "GH": "گھانا",
        "GI": "جبل الطارق",
        "GL": "گرین لینڈ",
        "GM": "گامبیا",
        "GN": "گنی",
        "GP": "گواڈیلوپ",
        "GQ": "استوائی گیانا",
        "GR": "یونان",
        "GS": "جنوبی جارجیا اور جنوبی سینڈوچ جزائر",
        "GT": "گواٹے مالا",
        "GU": "گوآم",
        "GW": "گنی بساؤ",
        "GY": "گیانا",
        "HK": "ہانگ کانگ SAR چین",
        "HM": "ہیئرڈ آئلینڈ اور میکڈونالڈ آئلینڈز",
        "HN": "ہونڈاروس",
        "HR": "کروشیا",
        "HT": "ہیتی",
        "HU": "ہنگری",
        "IC": "کینری آئلینڈز",
        "ID": "انڈونیشیا",
        "IE": "آئرلینڈ",
        "IL": "اسرائیل",
        "IM": "آئل آف مین",
        "IN": "بھارت",
        "IO": "برطانوی ہندوستانی سمندری خطہ",
        "IQ": "عراق",
        "IR": "ایران",
        "IS": "آئس لینڈ",
        "IT": "اٹلی",
        "JE": "جرسی",
        "JM": "جمائیکا",
        "JO": "اردن",
        "JP": "جاپان",
        "KE": "کینیا",
        "KG": "کرغزستان",
        "KH": "کمبوڈیا",
        "KI": "کریباتی",
        "KM": "کوموروس",
        "KN": "سینٹ کٹس اور نیویس",
        "KP": "شمالی کوریا",
        "KR": "جنوبی کوریا",
        "KW": "کویت",
        "KY": "کیمین آئلینڈز",
        "KZ": "قزاخستان",
        "LA": "لاؤس",
        "LB": "لبنان",
        "LC": "سینٹ لوسیا",
        "LI": "لیشٹنسٹائن",
        "LK": "سری لنکا",
        "LR": "لائبیریا",
        "LS": "لیسوتھو",
        "LT": "لتھوانیا",
        "LU": "لگژمبرگ",
        "LV": "لٹویا",
        "LY": "لیبیا",
        "MA": "مراقش",
        "MC": "موناکو",
        "MD": "مالدووا",
        "ME": "مونٹے نیگرو",
        "MF": "سینٹ مارٹن",
        "MG": "مڈغاسکر",
        "MH": "مارشل آئلینڈز",
        "MK": "مقدونیہ",
        "ML": "مالی",
        "MM": "میانمار (برما)",
        "MN": "منگولیا",
        "MO": "مکاؤ SAR چین",
        "MP": "شمالی ماریانا آئلینڈز",
        "MQ": "مارٹینک",
        "MR": "موریطانیہ",
        "MS": "مونٹسیراٹ",
        "MT": "مالٹا",
        "MU": "ماریشس",
        "MV": "مالدیو",
        "MW": "ملاوی",
        "MX": "میکسیکو",
        "MY": "ملیشیا",
        "MZ": "موزمبیق",
        "NA": "نامیبیا",
        "NC": "نیو کلیڈونیا",
        "NE": "نائجر",
        "NF": "نار فاک آئلینڈ",
        "NG": "نائجیریا",
        "NI": "نکاراگووا",
        "NL": "نیدر لینڈز",
        "NO": "ناروے",
        "NP": "نیپال",
        "NR": "نؤرو",
        "NU": "نیئو",
        "NZ": "نیوزی ینڈ",
        "OM": "عمان",
        "PA": "پنامہ",
        "PE": "پیرو",
        "PF": "فرانسیسی پولینیشیا",
        "PG": "پاپوآ نیو گنی",
        "PH": "فلپائنی",
        "PK": "پاکستان",
        "PL": "پولینڈ",
        "PM": "سینٹ پیئر اور میکلیئون",
        "PN": "پٹکائرن جزائر",
        "PR": "پیورٹو ریکو",
        "PS": "فلسطینی خطے",
        "PT": "پرتگال",
        "PW": "پلاؤ",
        "PY": "پیراگوئے",
        "QA": "قطر",
        "QO": "بیرونی اوشیانیا",
        "RE": "ری یونین",
        "RO": "رومانیا",
        "RS": "سربیا",
        "RU": "روسی",
        "RW": "روانڈا",
        "SA": "سعودی عرب",
        "SB": "سولومن آئلینڈز",
        "SC": "سشلیز",
        "SD": "سوڈان",
        "SE": "سویڈن",
        "SG": "سنگاپور",
        "SH": "سینٹ ہیلینا",
        "SI": "سلووینیا",
        "SJ": "سوالبرڈ اور جان ماین",
        "SK": "سلوواکیہ",
        "SL": "سیئر لیون",
        "SM": "سان مارینو",
        "SN": "سینیگل",
        "SO": "صومالیہ",
        "SR": "سورینام",
        "SS": "جنوبی سوڈان",
        "ST": "ساؤ ٹوم اور پرنسپے",
        "SV": "ال سلواڈور",
        "SX": "سنٹ مارٹن",
        "SY": "شام",
        "SZ": "سوازی لینڈ",
        "TA": "ٹرسٹن ڈا کیونہا",
        "TC": "ترکس اور کیکاؤس جزائر",
        "TD": "چاڈ",
        "TF": "فرانسیسی جنوبی خطے",
        "TG": "ٹوگو",
        "TH": "تھائی لینڈ",
        "TJ": "تاجکستان",
        "TK": "ٹوکیلاؤ",
        "TL": "تیمور لیسٹ",
        "TM": "ترکمانستان",
        "TN": "تیونیسیا",
        "TO": "ٹونگا",
        "TR": "ترکی",
        "TT": "ترینیداد اور ٹوباگو",
        "TV": "ٹووالو",
        "TW": "تائیوان",
        "TZ": "تنزانیہ",
        "UA": "یوکرین",
        "UG": "یوگانڈا",
        "UM": "امریکہ سے باہر کے چھوٹے جزائز",
        "US": "ریاستہائے متحدہ",
        "UY": "یوروگوئے",
        "UZ": "ازبکستان",
        "VA": "واٹیکن سٹی",
        "VC": "سینٹ ونسنٹ اور گرینیڈائنز",
        "VE": "وینزوئیلا",
        "VG": "برٹش ورجن آئلینڈز",
        "VI": "امریکی ورجن آئلینڈز",
        "VN": "ویتنام",
        "VU": "وینوآٹو",
        "WF": "ویلیز اور فیوٹیونا",
        "WS": "ساموآ",
        "XK": "کوسووو",
        "YE": "یمن",
        "YT": "مایوٹ",
        "ZA": "جنوبی افریقہ",
        "ZM": "زامبیا",
        "ZW": "زمبابوے",
        "ZZ": "نامعلوم علاقہ"
    };
  }-*/;
}
