/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.ChromatogramTargetsContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.views.AbstractTargetsView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ChromatogramTargetsView
extends AbstractTargetsView {
    @Inject
    private Composite parent;
    @Inject
    private EPartService partService;
    @Inject
    private MPart part;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;
    private IChromatogramSelectionMSD chromatogramSelection;

    @Inject
    public ChromatogramTargetsView(IEventBroker eventBroker) {
        super((IStructuredContentProvider)new ChromatogramTargetsContentProvider(), eventBroker);
        this.eventBroker = eventBroker;
    }

    @PostConstruct
    private void createControl() {
        super.createPartControl(this.parent);
        this.subscribe();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        super.setFocus();
        this.update(this.chromatogramSelection, false);
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    ChromatogramTargetsView.this.chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
                    event.getProperty("ForceReload");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    ChromatogramTargetsView.this.update(ChromatogramTargetsView.this.chromatogramSelection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/chromatogramselection", this.eventHandler);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private boolean doUpdate(IChromatogramSelectionMSD chromatogramSelection) {
        return this.isPartVisible() && chromatogramSelection != null;
    }

    private boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            super.update((Object)chromatogramSelection.getChromatogramMSD(), forceReload);
            this.getTableViewer().getTable().setSelection(0);
        }
    }
}

