/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRColPivDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.alg.dense.linsol.qr.BaseLinearSolverQrp_D64;
import org.ejml.data.DenseMatrix64F;

public class LinearSolverQrpHouseCol_D64
extends BaseLinearSolverQrp_D64 {
    private QRColPivDecompositionHouseholderColumn_D64 decomposition;
    private DenseMatrix64F x_basic = new DenseMatrix64F(1, 1);

    public LinearSolverQrpHouseCol_D64(QRColPivDecompositionHouseholderColumn_D64 decomposition, boolean norm2Solution) {
        super(decomposition, norm2Solution);
        this.decomposition = decomposition;
    }

    @Override
    public void solve(DenseMatrix64F B, DenseMatrix64F X) {
        if (X.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (B.numRows != this.numRows || B.numCols != X.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int BnumCols = B.numCols;
        int[] pivots = this.decomposition.getPivots();
        double[][] qr = this.decomposition.getQR();
        double[] gammas = this.decomposition.getGammas();
        int colB = 0;
        while (colB < BnumCols) {
            this.x_basic.reshape(this.numRows, 1);
            this.Y.reshape(this.numRows, 1);
            int i = 0;
            while (i < this.numRows) {
                this.x_basic.data[i] = B.get(i, colB);
                ++i;
            }
            i = 0;
            while (i < this.rank) {
                double[] u = qr[i];
                double vv = u[i];
                u[i] = 1.0;
                QrHelperFunctions_D64.rank1UpdateMultR(this.x_basic, u, gammas[i], 0, i, this.numRows, this.Y.data);
                u[i] = vv;
                ++i;
            }
            TriangularSolver.solveU(this.R11.data, this.x_basic.data, this.rank);
            this.x_basic.reshape(this.numCols, 1, true);
            i = this.rank;
            while (i < this.numCols) {
                this.x_basic.data[i] = 0.0;
                ++i;
            }
            if (this.norm2Solution && this.rank < this.numCols) {
                this.upgradeSolution(this.x_basic);
            }
            i = 0;
            while (i < this.numCols) {
                X.set(pivots[i], colB, this.x_basic.data[i]);
                ++i;
            }
            ++colB;
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposition.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

