/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.peak;

import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.AbstractStackedPeakLineSeriesUI;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class StackedPeakUI
extends AbstractStackedPeakLineSeriesUI {
    public StackedPeakUI(Composite parent, int style, IAxisTitles axisTitles) {
        super(parent, style, axisTitles);
    }

    public void setViewSeries() {
        String colorSchemeOverlay = PreferenceSupplier.getColorSchemeOverlay();
        IColorScheme colorScheme = Colors.getColorScheme((String)colorSchemeOverlay);
        int counter = 1;
        for (IPeakMSD peak : this.peakListMSD) {
            ISeries series = SeriesConverter.convertPeak((IPeak)peak, (boolean)false, (Sign)Sign.POSITIVE);
            this.addSeries(series);
            ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, "Peak [" + counter + "]");
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(colorScheme.getColor());
            colorScheme.incrementColor();
            ++counter;
        }
    }
}

