/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.msd.identifier.ui.runnables.PeakIdentifierRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteUnidentifiedPeaksHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(DeleteUnidentifiedPeaksHandler.class);
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(UISynchronize uiSynchronize, @Named(value="activeShell") Shell shell) {
        IChromatogramMSD chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogramMSD()) != null) {
            MessageBox messageBox = new MessageBox(shell, 456);
            messageBox.setText("Delete All Unidentified Peaks");
            messageBox.setMessage("Do you really want to delete all unidentified peaks?");
            int decision = messageBox.open();
            if (64 == decision) {
                StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start delete peaks without identifications.");
                ProgressMonitorDialog monitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                try {
                    monitor.run(true, true, (IRunnableWithProgress)new PeakIdentifierRunnable(chromatogramSelection));
                }
                catch (InvocationTargetException e) {
                    logger.warn((Object)e);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)e);
                }
                StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: Unidentified Peak(s) deleted");
            }
        }
    }

    public void handleEvent(Event event) {
        chromatogramSelection = event.getTopic().equals("chromatogram/msd/update/chromatogramselection") ? (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection") : null;
    }
}

