/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.baseline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.chemclipse.model.baseline.BaselineSegment;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.baseline.IBaselineSegment;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;

public class BaselineModel
implements IBaselineModel {
    private transient IChromatogram chromatogram;
    private NavigableMap<Integer, IBaselineSegment> baselineSegments = null;

    public BaselineModel(IChromatogram chromatogram) {
        this.chromatogram = chromatogram;
        this.clearBaseline();
    }

    @Override
    public void addBaseline(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance, float stopBackgroundAbundance, boolean validate) {
        if (validate) {
            this.addBaselineChecked(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance);
        } else {
            this.addBaselineUnchecked(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance);
        }
    }

    @Override
    public void removeBaseline(int startRetentionTime, int stopRetentionTime) {
        if (startRetentionTime >= stopRetentionTime) {
            return;
        }
        this.addBaseline(startRetentionTime, stopRetentionTime, 0.0f, 0.0f, true);
    }

    @Override
    public void removeBaseline() {
        this.clearBaseline();
    }

    @Override
    public float getBackgroundAbundance(int retentionTime) {
        if (retentionTime < this.chromatogram.getStartRetentionTime() || retentionTime > this.chromatogram.getStopRetentionTime()) {
            return 0.0f;
        }
        Map.Entry<Integer, IBaselineSegment> entry = this.baselineSegments.floorEntry(retentionTime);
        if (entry == null) {
            return 0.0f;
        }
        IBaselineSegment segment = entry.getValue();
        Point p1 = new Point((double)segment.getStartRetentionTime(), (double)segment.getStartBackgroundAbundance());
        Point p2 = new Point((double)segment.getStopRetentionTime(), (double)segment.getStopBackgroundAbundance());
        LinearEquation eq = Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
        return (float)eq.calculateY((double)retentionTime);
    }

    @Override
    public IBaselineModel makeDeepCopy() {
        BaselineModel baselineModelCopy = new BaselineModel(this.chromatogram);
        for (IBaselineSegment segment : this.baselineSegments.values()) {
            int startRT = segment.getStartRetentionTime();
            int stopRT = segment.getStopRetentionTime();
            float startAB = segment.getStartBackgroundAbundance();
            float stopAB = segment.getStopBackgroundAbundance();
            baselineModelCopy.addBaseline(startRT, stopRT, startAB, stopAB, true);
        }
        return baselineModelCopy;
    }

    private void addBaselineUnchecked(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance, float stopBackgroundAbundance) {
        BaselineSegment segment = new BaselineSegment(startRetentionTime, stopRetentionTime);
        segment.setStartBackgroundAbundance(startBackgroundAbundance);
        segment.setStopBackgroundAbundance(stopBackgroundAbundance);
        this.baselineSegments.put(segment.getStartRetentionTime(), segment);
    }

    private void addBaselineChecked(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance, float stopBackgroundAbundance) {
        if (startRetentionTime >= stopRetentionTime) {
            return;
        }
        ArrayList<IBaselineSegment> addSegments = new ArrayList<IBaselineSegment>();
        ArrayList<Integer> removeSegments = new ArrayList<Integer>();
        int start = startRetentionTime;
        int stop = stopRetentionTime;
        IBaselineSegment segment = new BaselineSegment(start, stop);
        segment.setStartBackgroundAbundance(startBackgroundAbundance);
        segment.setStopBackgroundAbundance(stopBackgroundAbundance);
        addSegments.add(segment);
        for (Integer key : this.baselineSegments.keySet()) {
            segment = (IBaselineSegment)this.baselineSegments.get(key);
            int x0 = segment.getStartRetentionTime();
            int x1 = segment.getStopRetentionTime();
            if (start < x0 && stop < x0 || start > x1 && stop > x1) continue;
            if (start < x0 && stop > x1) {
                removeSegments.add(key);
                continue;
            }
            if (stop > x0 && stop < x1 && start < x0) {
                this.cutSegmentsBeginningPart(stop, segment, removeSegments, addSegments, key);
            }
            if (start < x1 && stop >= x1) {
                this.cutSegmentsEndingPart(start, segment, removeSegments, key);
            }
            if (start <= x0 || start >= x1 || stop <= x0 || stop >= x1) continue;
            this.cutExistingSegmentInTwoParts(start, stop, segment, removeSegments, addSegments, key);
        }
        for (Integer key : removeSegments) {
            this.baselineSegments.remove(key);
        }
        for (IBaselineSegment addSegment : addSegments) {
            this.baselineSegments.put(addSegment.getStartRetentionTime(), addSegment);
        }
    }

    private void cutSegmentsBeginningPart(int stop, IBaselineSegment segment, List<Integer> removeSegments, List<IBaselineSegment> addSegments, int key) {
        int startRT = stop + 1;
        if (startRT == 0) {
            removeSegments.add(key);
        } else {
            removeSegments.add(key);
            segment.setStartBackgroundAbundance(this.getBackgroundAbundance(startRT));
            segment.setStartRetentionTime(startRT);
            addSegments.add(segment);
        }
    }

    private void cutSegmentsEndingPart(int start, IBaselineSegment segment, List<Integer> removeSegments, int key) {
        int stopRT = start - 1;
        if (stopRT == 0) {
            removeSegments.add(key);
        } else {
            segment.setStopBackgroundAbundance(this.getBackgroundAbundance(stopRT));
            segment.setStopRetentionTime(stopRT);
        }
    }

    private void cutExistingSegmentInTwoParts(int start, int stop, IBaselineSegment segment, List<Integer> removeSegments, List<IBaselineSegment> addSegments, int key) {
        int startRT = stop + 1;
        if (startRT == this.chromatogram.getStopRetentionTime()) {
            removeSegments.add(key);
        } else {
            BaselineSegment segmentII = new BaselineSegment(startRT, segment.getStopRetentionTime());
            segmentII.setStartBackgroundAbundance(this.getBackgroundAbundance(startRT));
            segmentII.setStopBackgroundAbundance(segment.getStopBackgroundAbundance());
            addSegments.add(segmentII);
        }
        int stopRT = start - 1;
        if (stopRT == 0) {
            removeSegments.add(key);
        } else {
            removeSegments.add(key);
            segment.setStopBackgroundAbundance(this.getBackgroundAbundance(stopRT));
            segment.setStopRetentionTime(stopRT);
            addSegments.add(segment);
        }
    }

    private void clearBaseline() {
        if (this.baselineSegments != null && this.baselineSegments.size() > 0) {
            this.baselineSegments.clear();
        }
        this.baselineSegments = new TreeMap<Integer, IBaselineSegment>();
    }
}

