/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import org.eclipse.chemclipse.model.support.ITwoPoints;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.exceptions.PointIsNullException;

public class TwoPoints
implements ITwoPoints {
    private IPoint p1;
    private IPoint p2;

    public TwoPoints(IPoint p1, IPoint p2) throws PointIsNullException {
        if (p1 == null || p2 == null) {
            throw new PointIsNullException("The points p1 and p2 must not be null.");
        }
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    public LinearEquation getLinearEquation() {
        return Equations.createLinearEquation((IPoint)this.p1, (IPoint)this.p2);
    }

    @Override
    public IPoint getPoint1() {
        return this.p1;
    }

    @Override
    public IPoint getPoint2() {
        return this.p2;
    }

    @Override
    public double getSlope() {
        return Equations.calculateSlope((IPoint)this.p1, (IPoint)this.p2);
    }
}

