/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support;

import java.util.ArrayList;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.IChromatogramIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ChromatogramIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.core.BackgroundIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.core.ChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.ITrapezoidChromatogramIntegratorSupport;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.implementation.IntegrationEntryCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.IntegrationEntryMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class TrapezoidChromatogramIntegratorSupport
implements ITrapezoidChromatogramIntegratorSupport {
    public static final String INTEGRATOR_DESCRIPTION = "Integrator Trapezoid";

    @Override
    public IChromatogramIntegrationResults calculateChromatogramIntegrationResults(IChromatogramSelection chromatogramSelection, IChromatogramIntegrationSettings chromatogramIntegrationSettings, IProgressMonitor monitor) {
        IIntegrationEntry chromatogramIntegrationEntry = this.calculateChromatogramIntegrationEntry(chromatogramSelection, monitor);
        IIntegrationEntry backgroundIntegrationEntry = this.calculateBackgroundIntegrationEntry(chromatogramSelection, monitor);
        double chromatogramArea = 0.0;
        double backgroundArea = 0.0;
        if (chromatogramIntegrationEntry != null) {
            chromatogramArea = chromatogramIntegrationEntry.getIntegratedArea();
        }
        if (backgroundIntegrationEntry != null) {
            backgroundArea = backgroundIntegrationEntry.getIntegratedArea();
        }
        ChromatogramIntegrationResults chromatogramIntegrationResults = new ChromatogramIntegrationResults();
        ChromatogramIntegrationResult chromatogramIntegrationResult = new ChromatogramIntegrationResult(chromatogramArea, backgroundArea);
        chromatogramIntegrationResults.add((IChromatogramIntegrationResult)chromatogramIntegrationResult);
        return chromatogramIntegrationResults;
    }

    private IIntegrationEntry calculateChromatogramIntegrationEntry(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        monitor.subTask("Integrate the chromatogram area");
        ChromatogramIntegrator chromatogramIntegrator = new ChromatogramIntegrator();
        double chromatogramArea = chromatogramIntegrator.integrate(chromatogramSelection);
        IntegrationEntryMSD chromatogramIntegrationEntry = null;
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            chromatogramIntegrationEntry = new IntegrationEntryMSD(0.0, chromatogramArea);
        } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            chromatogramIntegrationEntry = new IntegrationEntryCSD(chromatogramArea);
        }
        if (chromatogramIntegrationEntry != null) {
            ArrayList<IntegrationEntryMSD> chromatogramIntegrationEntries = new ArrayList<IntegrationEntryMSD>();
            chromatogramIntegrationEntries.add(chromatogramIntegrationEntry);
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            chromatogram.setChromatogramIntegratedArea(chromatogramIntegrationEntries, INTEGRATOR_DESCRIPTION);
        }
        return chromatogramIntegrationEntry;
    }

    private IIntegrationEntry calculateBackgroundIntegrationEntry(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        monitor.subTask("Integrate the background area");
        BackgroundIntegrator backgroundIntegrator = new BackgroundIntegrator();
        double backgroundArea = backgroundIntegrator.integrate(chromatogramSelection);
        IntegrationEntryMSD backgroundIntegrationEntry = null;
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            backgroundIntegrationEntry = new IntegrationEntryMSD(0.0, backgroundArea);
        } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            backgroundIntegrationEntry = new IntegrationEntryCSD(backgroundArea);
        }
        if (backgroundIntegrationEntry != null) {
            ArrayList<IntegrationEntryMSD> backgroundIntegrationEntries = new ArrayList<IntegrationEntryMSD>();
            backgroundIntegrationEntries.add(backgroundIntegrationEntry);
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            chromatogram.setBackgroundIntegratedArea(backgroundIntegrationEntries, INTEGRATOR_DESCRIPTION);
        }
        return backgroundIntegrationEntry;
    }
}

