/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.csd.converter.io.IChromatogramCSDWriter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IIntegrationEntryCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter_1004
extends AbstractChromatogramWriter
implements IChromatogramCSDWriter {
    public void writeChromatogram(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        monitor.subTask("Export Chromatogram");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeVersion(zipOutputStream, monitor);
        this.writeChromatogramFolder(zipOutputStream, chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    private void writeVersion(ZipOutputStream zipOutputStream, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "1.0.0.4";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("FID/CHROMATOGRAM/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        this.writeChromatogramScans(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramBaseline(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramPeaks(zipOutputStream, chromatogram, monitor);
        this.writeChromatogramArea(zipOutputStream, chromatogram, monitor);
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("FID/CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Export Scan: " + scan);
            IScanCSD scanFID = chromatogram.getSupplierScan(scan);
            dataOutputStream.writeInt(scanFID.getRetentionTime());
            dataOutputStream.writeFloat(scanFID.getRetentionIndex());
            dataOutputStream.writeFloat(scanFID.getTotalSignal());
            dataOutputStream.writeInt(scanFID.getTimeSegmentId());
            dataOutputStream.writeInt(scanFID.getCycleNumber());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramBaseline(ZipOutputStream zipOutputStream, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("FID/CHROMATOGRAM/BASELINE");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Export Basline: " + scan);
            int retentionTime = chromatogram.getSupplierScan(scan).getRetentionTime();
            float backgroundAbundance = baselineModel.getBackgroundAbundance(retentionTime);
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(backgroundAbundance);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramPeaks(ZipOutputStream zipOutputStream, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("FID/CHROMATOGRAM/PEAKS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List peaks = chromatogram.getPeaks();
        dataOutputStream.writeInt(peaks.size());
        int counter = 1;
        for (IChromatogramPeakCSD peak : peaks) {
            monitor.subTask("Export Peak: " + counter++);
            this.writePeak(dataOutputStream, (IPeakCSD)peak);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramArea(ZipOutputStream zipOutputStream, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("FID/CHROMATOGRAM/AREA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramIntegrationEntries = chromatogram.getChromatogramIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getChromatogramIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, chromatogramIntegrationEntries);
        List backgroundIntegrationEntries = chromatogram.getBackgroundIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getBackgroundIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, backgroundIntegrationEntries);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writePeak(DataOutputStream dataOutputStream, IPeakCSD peak) throws IOException {
        IPeakModelCSD peakModel = peak.getPeakModel();
        this.writeString(dataOutputStream, peak.getDetectorDescription());
        this.writeString(dataOutputStream, peak.getIntegratorDescription());
        this.writeString(dataOutputStream, peak.getModelDescription());
        this.writeString(dataOutputStream, peak.getPeakType().toString());
        dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IScan scan = peakModel.getPeakMaximum();
        dataOutputStream.writeInt(scan.getRetentionTime());
        dataOutputStream.writeFloat(scan.getRetentionIndex());
        dataOutputStream.writeFloat(scan.getTotalSignal());
        dataOutputStream.writeInt(scan.getTimeSegmentId());
        dataOutputStream.writeInt(scan.getCycleNumber());
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        this.writeIntegrationEntries(dataOutputStream, integrationEntries);
    }

    private void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            if (!(iIntegrationEntry instanceof IIntegrationEntryCSD)) continue;
            IIntegrationEntryCSD integrationEntryFID = (IIntegrationEntryCSD)iIntegrationEntry;
            dataOutputStream.writeDouble(integrationEntryFID.getIntegratedArea());
        }
    }

    private void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

