/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.wsd.converter.io.AbstractChromatogramWSDReader;
import org.eclipse.chemclipse.wsd.converter.io.IChromatogramWSDReader;

public abstract class AbstractChromatogramReader
extends AbstractChromatogramWSDReader
implements IChromatogramWSDReader {
    public DataInputStream getDataInputStream(ZipFile zipFile, String entryName) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory() || !(name = zipEntry.getName()).equals(entryName)) continue;
            return new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
        }
        throw new IOException("There could be found no entry given with the name: " + entryName);
    }

    public String readString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= length) {
            builder.append(String.valueOf(dataInputStream.readChar()));
            ++i;
        }
        return builder.toString();
    }
}

