/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.internal.support;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;

public class ChromatogramIdentifier {
    private static List<ISupplier> suppliers;

    public static boolean isChromatogram(File file) {
        String extension = file.toString().toLowerCase();
        if (file.isDirectory()) {
            return false;
        }
        if (suppliers == null) {
            suppliers = ChromatogramConverterCSD.getChromatogramConverterSupport().getSupplier();
        } else {
            for (ISupplier supplier : suppliers) {
                String supplierExtension = supplier.getFileExtension().toLowerCase();
                if (supplierExtension == "" || !extension.endsWith(supplierExtension)) continue;
                return supplier.isImportable();
            }
        }
        return false;
    }

    public static boolean isChromatogramDirectory(File file) {
        String directory = file.toString().toUpperCase();
        if (!file.isDirectory()) {
            return false;
        }
        if (suppliers == null) {
            suppliers = ChromatogramConverterCSD.getChromatogramConverterSupport().getSupplier();
        } else {
            for (ISupplier supplier : suppliers) {
                String directoryExtension = supplier.getDirectoryExtension().toUpperCase();
                if (directoryExtension == "" || !directory.endsWith(directoryExtension)) continue;
                return supplier.isImportable();
            }
        }
        return false;
    }
}

