/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.equinox.internal.transforms.LazyInputStream;
import org.eclipse.equinox.internal.transforms.StreamTransformer;
import org.eclipse.equinox.internal.transforms.TransformTuple;
import org.eclipse.equinox.internal.transforms.TransformedBundleEntry;
import org.eclipse.equinox.internal.transforms.TransformerHook;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.StorageUtil;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.osgi.framework.Bundle;

public class TransformedBundleFile
extends BundleFileWrapper {
    private final TransformerHook transformerHook;
    private final BundleFile delegate;
    private final BundleInfo.Generation generation;
    private final Debug debug;

    public TransformedBundleFile(TransformerHook transformerHook, BundleInfo.Generation generation, BundleFile delegate) {
        super(delegate);
        this.transformerHook = transformerHook;
        this.generation = generation;
        this.delegate = delegate;
        this.debug = generation.getBundleInfo().getStorage().getConfiguration().getDebug();
    }

    BundleInfo.Generation getGeneration() {
        return this.generation;
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public BundleEntry getEntry(String path) {
        final BundleEntry original = this.delegate.getEntry(path);
        if (this.generation.getRevision() == null || path == null || original == null) {
            return original;
        }
        LazyInputStream stream = new LazyInputStream(new LazyInputStream.InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                return original.getInputStream();
            }
        });
        InputStream wrappedStream = this.getInputStream(stream, this.generation.getRevision().getBundle(), path);
        if (wrappedStream == null) {
            return original;
        }
        return new TransformedBundleEntry(this, original, wrappedStream);
    }

    protected InputStream getInputStream(InputStream inputStream, Bundle bundle, String path) {
        String namespace = bundle.getSymbolicName();
        String[] transformTypes = this.transformerHook.getTransformTypes();
        if (transformTypes.length == 0) {
            return null;
        }
        int i = 0;
        while (i < transformTypes.length) {
            TransformTuple[] transformTuples;
            StreamTransformer transformer = this.transformerHook.getTransformer(transformTypes[i]);
            if (transformer != null && (transformTuples = this.transformerHook.getTransformsFor(transformTypes[i])) != null) {
                int j = 0;
                while (j < transformTuples.length) {
                    TransformTuple transformTuple = transformTuples[j];
                    if (this.match(transformTuple.bundlePattern, namespace) && this.match(transformTuple.pathPattern, path)) {
                        try {
                            return transformer.getInputStream(inputStream, transformTuple.transformerUrl);
                        }
                        catch (IOException e) {
                            this.generation.getBundleInfo().getStorage().getLogServices().log("org.eclipse.osgi", 4, "Problem obtaining transformed stream from transformer : " + transformer.getClass().getName(), (Throwable)e);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private boolean match(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getFile(String path, boolean nativeCode) {
        InputStream in;
        File nested;
        block11: {
            File originalFile = this.delegate.getFile(path, nativeCode);
            if (originalFile == null) {
                return null;
            }
            if (!this.hasTransforms(path)) {
                return originalFile;
            }
            nested = this.getExtractFile(path);
            if (nested == null) return null;
            if (nested.exists()) {
                if (this.debug.DEBUG_GENERAL) {
                    Debug.println((String)("File already present: " + nested.getPath()));
                }
                if (!nested.isDirectory()) return nested;
                this.extractDirectory(path);
                return nested;
            }
            if (originalFile.isDirectory()) {
                if (!nested.mkdirs()) {
                    throw new IOException("Unable to create directory: " + nested.getAbsolutePath());
                }
                this.extractDirectory(path);
                return nested;
            }
            in = this.getEntry(path).getInputStream();
            if (in != null) break block11;
            return null;
        }
        try {
            File dir;
            if (this.debug.DEBUG_GENERAL) {
                Debug.println((String)("Creating file: " + nested.getPath()));
            }
            if (!(dir = new File(nested.getParent())).exists() && !dir.mkdirs()) {
                throw new IOException("Unable to create directory: " + dir.getAbsolutePath());
            }
            StorageUtil.readFile((InputStream)in, (File)nested);
            if (!nativeCode) return nested;
            this.generation.getBundleInfo().getStorage().setPermissions(nested);
            return nested;
        }
        catch (IOException e) {
            if (!this.debug.DEBUG_GENERAL) return null;
            Debug.printStackTrace((Throwable)e);
        }
        return null;
    }

    private boolean hasTransforms(String path) {
        if (!this.transformerHook.hasTransformers()) {
            return false;
        }
        return this.transformerHook.hasTransformsFor(this.generation.getRevision().getBundle());
    }

    protected synchronized File extractDirectory(String dirName) {
        Enumeration entries = this.delegate.getEntryPaths(dirName);
        while (entries.hasMoreElements()) {
            String entryPath = (String)entries.nextElement();
            if (!entryPath.startsWith(dirName)) continue;
            this.getFile(entryPath, false);
        }
        return this.getExtractFile(dirName);
    }

    protected File getExtractFile(String entryName) {
        String path = ".tf";
        String name = entryName.replace('/', File.separatorChar);
        path = name.length() > 1 && name.charAt(0) == File.separatorChar ? path.concat(name) : String.valueOf(path) + File.separator + name;
        return this.generation.getExtractFile(path);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

