/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.http.NoHttpResponseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCorePlugin;
import org.eclipse.epp.internal.mpc.core.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class MarketplaceClientCore {
    public static final String BUNDLE_ID = "org.eclipse.epp.mpc.core";
    private static final String STREAM_CLOSED_MESSAGE = "Stream closed";
    private static final String PIPE_CLOSED_MESSAGE = "Pipe closed";
    private static final String PIPE_BROKEN_MESSAGE = "Pipe broken";

    public static ILog getLog() {
        return Platform.getLog((Bundle)MarketplaceClientCorePlugin.getBundle());
    }

    public static void error(String message, Throwable exception) {
        if (message == null) {
            message = NLS.bind((String)Messages.MarketplaceClientCore_unexpectedException, (Object)exception.getMessage());
        }
        MarketplaceClientCore.getLog().log((IStatus)new Status(4, BUNDLE_ID, 4, message, exception));
    }

    public static void error(Throwable exception) {
        MarketplaceClientCore.error(null, exception);
    }

    public static IStatus computeStatus(Exception e, String message) {
        Object statusCause;
        Throwable cause = e;
        if (e instanceof InvocationTargetException) {
            cause = e.getCause();
        }
        if ((statusCause = MarketplaceClientCore.computeWellknownProblemStatus(e)) == null) {
            statusCause = cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, BUNDLE_ID, cause.getMessage(), cause);
        }
        if (statusCause.getMessage() != null) {
            message = NLS.bind((String)Messages.MarketplaceClientCore_message_message2, (Object)message, (Object)statusCause.getMessage());
        }
        MultiStatus status = new MultiStatus(BUNDLE_ID, 0, new IStatus[]{statusCause}, message, cause);
        return status;
    }

    public static IStatus computeWellknownProblemStatus(Throwable exception) {
        Status status = null;
        while (exception != null) {
            IStatus exceptionStatus;
            if (exception instanceof FileNotFoundException) {
                status = new Status(4, BUNDLE_ID, NLS.bind((String)Messages.MarketplaceClientCore_notFound, (Object)exception.getMessage()), exception);
                break;
            }
            if (exception instanceof UnknownHostException) {
                status = new Status(4, BUNDLE_ID, NLS.bind((String)Messages.MarketplaceClientCore_unknownHost, (Object)exception.getMessage()), exception);
                break;
            }
            if (exception instanceof NoRouteToHostException) {
                status = new Status(4, BUNDLE_ID, NLS.bind((String)Messages.MarketplaceClientCore_unknownHost, (Object)exception.getMessage()), exception);
                break;
            }
            if (exception instanceof ConnectException) {
                status = MarketplaceClientCore.createConnectionProblemStatus(exception);
                break;
            }
            if (exception instanceof SocketException) {
                status = MarketplaceClientCore.createConnectionProblemStatus(exception);
                break;
            }
            if (exception instanceof SocketTimeoutException) {
                status = MarketplaceClientCore.createConnectionProblemStatus(exception);
                break;
            }
            if (exception instanceof NoHttpResponseException) {
                status = MarketplaceClientCore.createConnectionProblemStatus(exception);
                break;
            }
            if (exception instanceof CoreException && BUNDLE_ID.equals((exceptionStatus = ((CoreException)exception).getStatus()).getPlugin()) && exceptionStatus.getCode() == 503) {
                status = new Status(4, BUNDLE_ID, exceptionStatus.getMessage(), exception);
                break;
            }
            Throwable cause = exception.getCause();
            if (cause == exception) break;
            exception = cause;
        }
        return status;
    }

    public static IStatus createConnectionProblemStatus(Throwable exception) {
        Status status = new Status(4, BUNDLE_ID, NLS.bind((String)Messages.MarketplaceClientCore_connectionProblem, (Object)exception.getMessage()), exception);
        return status;
    }

    public static boolean isStreamClosedException(Throwable exception) {
        return MarketplaceClientCore.isIOExceptionWithMessage(exception, STREAM_CLOSED_MESSAGE);
    }

    public static boolean isPipeClosedException(Throwable exception) {
        return MarketplaceClientCore.isIOExceptionWithMessage(exception, PIPE_CLOSED_MESSAGE);
    }

    public static boolean isPipeBrokenException(Throwable exception) {
        return MarketplaceClientCore.isIOExceptionWithMessage(exception, PIPE_BROKEN_MESSAGE);
    }

    public static boolean isFailedDownloadException(Throwable exception) {
        return MarketplaceClientCore.isStreamClosedException(exception) || MarketplaceClientCore.isPipeClosedException(exception) || MarketplaceClientCore.isPipeBrokenException(exception);
    }

    private static boolean isIOExceptionWithMessage(Throwable exception, String message) {
        while (exception != null) {
            if (exception instanceof IOException) {
                IOException ioException = (IOException)exception;
                return message.equals(ioException.getMessage());
            }
            Throwable cause = exception.getCause();
            if (cause == exception) break;
            exception = cause;
        }
        return false;
    }
}

