/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.internal.support.PeakMaxPeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.AbstractPeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IPeakIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.PeakIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResults;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIntegrator
extends AbstractPeakIntegrator {
    private static final Logger logger = Logger.getLogger(PeakIntegrator.class);

    public IPeakIntegratorProcessingInfo integrate(IPeak peak, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        PeakIntegratorProcessingInfo processingInfo = new PeakIntegratorProcessingInfo();
        try {
            super.validate(peak, peakIntegrationSettings);
            if (peak instanceof IPeakMSD) {
                IPeakMSD peakMSD = (IPeakMSD)peak;
                PeakMaxPeakIntegratorSupport peakMaxPeakIntegratorSupport = new PeakMaxPeakIntegratorSupport();
                IPeakIntegrationResult peakIntegrationResult = peakMaxPeakIntegratorSupport.calculatePeakIntegrationResult(peakMSD, peakIntegrationSettings, monitor);
                PeakIntegrationResults peakIntegrationResults = new PeakIntegrationResults();
                peakIntegrationResults.add(peakIntegrationResult);
                processingInfo.setPeakIntegrationResults((IPeakIntegrationResults)peakIntegrationResults);
            } else {
                this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
            }
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public IPeakIntegratorProcessingInfo integrate(IPeak peak, IProgressMonitor monitor) {
        IPeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(peak, peakIntegrationSettings, monitor);
    }

    public IPeakIntegratorProcessingInfo integrate(List<? extends IPeak> peaks, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        PeakIntegratorProcessingInfo processingInfo = new PeakIntegratorProcessingInfo();
        try {
            super.validate(peaks, peakIntegrationSettings);
            PeakMaxPeakIntegratorSupport peakMaxPeakIntegratorSupport = new PeakMaxPeakIntegratorSupport();
            ArrayList<IPeakMSD> peaksMSD = new ArrayList<IPeakMSD>();
            for (IPeak iPeak : peaks) {
                if (!(iPeak instanceof IPeakMSD)) continue;
                IPeakMSD peakMSD = (IPeakMSD)iPeak;
                peaksMSD.add(peakMSD);
            }
            IPeakIntegrationResults iPeakIntegrationResults = peakMaxPeakIntegratorSupport.calculatePeakIntegrationResults(peaksMSD, peakIntegrationSettings, monitor);
            processingInfo.setPeakIntegrationResults(iPeakIntegrationResults);
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public IPeakIntegratorProcessingInfo integrate(List<? extends IPeak> peaks, IProgressMonitor monitor) {
        IPeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(peaks, peakIntegrationSettings, monitor);
    }

    public IPeakIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        PeakIntegratorProcessingInfo processingInfo = new PeakIntegratorProcessingInfo();
        try {
            super.validate(chromatogramSelection, peakIntegrationSettings);
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                PeakMaxPeakIntegratorSupport peakMaxPeakIntegratorSupport = new PeakMaxPeakIntegratorSupport();
                IPeakIntegrationResults peakIntegrationResults = peakMaxPeakIntegratorSupport.calculatePeakIntegrationResults((IChromatogramSelectionMSD)chromatogramSelection, peakIntegrationSettings, monitor);
                processingInfo.setPeakIntegrationResults(peakIntegrationResults);
            } else {
                this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
            }
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public IPeakIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        IPeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(chromatogramSelection, peakIntegrationSettings, monitor);
    }

    private void addIntegratorExceptionInfo(IProcessingInfo processingInfo) {
        processingInfo.addErrorMessage("Peak Max Integrator", "The peak(s) or settings couldn't be validated correctly.");
    }
}

