/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.ProfileMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProfileMassSpectrumUIWithLabel
extends Composite
implements IChromatogramSelectionMSDUpdateNotifier {
    private ProfileMassSpectrumUI profileMassSpectrumUI;
    private Label label;
    private IScanMSD massSpectrum;
    private DecimalFormat decimalFormat;

    public ProfileMassSpectrumUIWithLabel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
        this.initialize();
    }

    private void initialize() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        Composite labelbar = new Composite(composite, 4);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        labelbar.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        labelbar.setLayoutData((Object)gridData);
        this.label = new Label(labelbar, 0);
        this.label.setText("");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.label.setLayoutData((Object)gridData);
        this.profileMassSpectrumUI = new ProfileMassSpectrumUI(composite, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.profileMassSpectrumUI.setLayoutData(gridData);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (chromatogramSelection != null && this.massSpectrum != chromatogramSelection.getSelectedScan()) {
            this.massSpectrum = chromatogramSelection.getSelectedScan();
            this.setMassSpectrumLabel(this.massSpectrum);
            this.profileMassSpectrumUI.update(chromatogramSelection, forceReload);
        }
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum) {
        StringBuilder builder = new StringBuilder();
        if (massSpectrum instanceof IVendorMassSpectrum) {
            IVendorMassSpectrum actualMassSpectrum = (IVendorMassSpectrum)massSpectrum;
            builder.append("Scan: ");
            builder.append(actualMassSpectrum.getScanNumber());
            builder.append(" | ");
            builder.append("RT: ");
            builder.append(this.decimalFormat.format((double)actualMassSpectrum.getRetentionTime() / 60000.0));
            builder.append(" | ");
            builder.append("RI: ");
            if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                builder.append(Integer.toString((int)actualMassSpectrum.getRetentionIndex()));
            } else {
                builder.append(this.decimalFormat.format(actualMassSpectrum.getRetentionIndex()));
            }
            builder.append(" | ");
            builder.append("Detector: MS");
            builder.append(actualMassSpectrum.getMassSpectrometer());
            builder.append(" | ");
            builder.append("Type: ");
            builder.append(actualMassSpectrum.getMassSpectrumTypeDescription());
            builder.append(" | ");
        }
        builder.append("Signal: ");
        builder.append((int)massSpectrum.getTotalSignal());
        this.label.setText(builder.toString());
    }
}

