/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.set.SimpleSetProperty;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListener;
import org.eclipse.core.internal.databinding.beans.TypedSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSetProperty<S, E>
extends SimpleSetProperty<S, E> {
    private final PropertyDescriptor propertyDescriptor;
    private final Class<E> elementType;

    public BeanSetProperty(PropertyDescriptor propertyDescriptor, Class<E> elementType) {
        if (elementType == null) {
            Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", "elementType cannot be null"));
            elementType = propertyDescriptor.getPropertyType().isArray() ? propertyDescriptor.getPropertyType().getComponentType() : Object.class;
        }
        BeanPropertyHelper.checkCollectionPropertyElementType(propertyDescriptor, elementType);
        this.propertyDescriptor = propertyDescriptor;
        this.elementType = elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    public Class<E> getElementClass() {
        return this.elementType;
    }

    protected Set<E> doGetSet(S source) {
        return this.asSet(BeanPropertyHelper.readProperty(source, this.propertyDescriptor));
    }

    private Set<E> asSet(Object propertyValue) {
        if (propertyValue == null) {
            return Collections.emptySet();
        }
        if (this.propertyDescriptor.getPropertyType().isArray()) {
            HashSet<E> result = new HashSet<E>();
            for (Object element : Arrays.asList((Object[])propertyValue)) {
                result.add(this.elementType.cast(element));
            }
            return result;
        }
        return new TypedSet<E>((Set)propertyValue, this.elementType);
    }

    protected void doSetSet(S source, Set<E> set, SetDiff<E> diff) {
        this.doSetSet(source, set);
    }

    protected void doSetSet(S source, Set<E> set) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, this.convertSetToBeanPropertyType(set));
    }

    private Object convertSetToBeanPropertyType(Set<E> set) {
        Object[] propertyValue = set;
        if (this.propertyDescriptor.getPropertyType().isArray()) {
            Class<?> componentType = this.propertyDescriptor.getPropertyType().getComponentType();
            Object[] array = (Object[])Array.newInstance(componentType, set.size());
            propertyValue = set.toArray(array);
        }
        return propertyValue;
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<SetDiff<E>> listener) {
        return new BeanPropertyListener<S, SetDiff<E>>((IProperty)this, this.propertyDescriptor, listener){

            @Override
            protected SetDiff<E> computeDiff(Object oldValue, Object newValue) {
                return Diffs.computeAndCastSetDiff((Set)BeanSetProperty.this.asSet(oldValue), (Set)BeanSetProperty.this.asSet(newValue), (Class)BeanSetProperty.this.elementType);
            }
        };
    }

    public String toString() {
        String s = String.valueOf(BeanPropertyHelper.propertyName(this.propertyDescriptor)) + "{}";
        if (this.elementType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.elementType) + ">";
        }
        return s;
    }
}

