/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.ui.editors;

import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.converter.ChromatogramImportConverter;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.converter.MagicNumberMatcherCSD;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.converter.MagicNumberMatcherMSD;
import org.eclipse.chemclipse.rcp.app.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.editors.AbstractExtendedEditorPage;
import org.eclipse.chemclipse.support.ui.editors.IExtendedEditorPage;
import org.eclipse.chemclipse.ux.extension.msd.ui.support.ChromatogramSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.IChromatogramEditorSupport;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.converter.MagicNumberMatcherWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PageChromatogram
extends AbstractExtendedEditorPage
implements IExtendedEditorPage {
    private File file;
    private Label labelName;
    private Label labelDataName;
    private Label labelOperator;
    private Label labelDate;
    private Label labelScans;
    private Label labelRTStart;
    private Label labelRTStop;
    private ImageHyperlink hyperlinkProcess;
    private MagicNumberMatcherMSD magicNumberMatcherMSD = new MagicNumberMatcherMSD();
    private MagicNumberMatcherCSD magicNumberMatcherCSD = new MagicNumberMatcherCSD();
    private MagicNumberMatcherWSD magicNumberMatcherWSD = new MagicNumberMatcherWSD();
    private SimpleDateFormat dateFormat = ValueFormat.getDateFormatEnglish();
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public PageChromatogram(Composite container) {
        super("Chromatogram", container, true);
    }

    public void fillBody(ScrolledForm scrolledForm) {
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new TableWrapLayout());
        body.setLayout((Layout)this.createFormTableWrapLayout(true, 3));
        this.createInfoSection(body);
        this.createProcessSection(body);
    }

    public void showData(File file) {
        this.file = file;
        this.hyperlinkProcess.setText("");
        this.labelName.setText("Name:");
        this.labelDataName.setText("Data Name:");
        this.labelOperator.setText("Operator:");
        this.labelDate.setText("Date:");
        this.labelScans.setText("Scans:");
        this.labelRTStart.setText("Start RT (min):");
        this.labelRTStop.setText("Stop RT (min):");
        if (file != null) {
            this.labelName.setText(file.getName());
            this.hyperlinkProcess.setText(file.getName());
            IChromatogramOverview chromatogramOverview = this.getChromatogramOverview(file);
            if (chromatogramOverview != null) {
                this.labelName.setText("Name: " + chromatogramOverview.getName());
                this.labelDataName.setText("Data Name: " + chromatogramOverview.getDataName());
                this.labelOperator.setText("Operator: " + chromatogramOverview.getOperator());
                Date date = chromatogramOverview.getDate();
                if (date != null) {
                    this.labelDate.setText("Date: " + this.dateFormat.format(chromatogramOverview.getDate()));
                } else {
                    this.labelDate.setText("Date: ");
                }
                this.labelScans.setText("Scans: " + Integer.toString(chromatogramOverview.getNumberOfScans()));
                this.labelRTStart.setText("Start RT (min): " + this.decimalFormat.format((double)chromatogramOverview.getStartRetentionTime() / 60000.0));
                this.labelRTStop.setText("Stop RT (min): " + this.decimalFormat.format((double)chromatogramOverview.getStopRetentionTime() / 60000.0));
            }
        }
    }

    private void createInfoSection(Composite parent) {
        Section section = this.createSection(parent, 3, "Overview", "Some header values of the file are displayed.");
        Composite client = this.createClientInfo(section);
        this.labelName = this.createLabel(client, "");
        this.labelDataName = this.createLabel(client, "");
        this.labelOperator = this.createLabel(client, "");
        this.labelDate = this.createLabel(client, "");
        this.labelScans = this.createLabel(client, "");
        this.labelRTStart = this.createLabel(client, "");
        this.labelRTStop = this.createLabel(client, "");
        section.setClient((Control)client);
    }

    private void createProcessSection(Composite parent) {
        Section section = this.createSection(parent, 3, "Open Raw File", "Just click on the button to open the evaluated chromatogram.");
        Composite client = this.createClient(section);
        this.createLabel(client, "Open Chromatogram");
        this.hyperlinkProcess = this.createProcessHyperlink(client);
        section.setClient((Control)client);
    }

    private ImageHyperlink createProcessHyperlink(Composite client) {
        ImageHyperlink imageHyperlink = this.getFormToolkit().createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        imageHyperlink.setText("");
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 15;
        gridData.verticalIndent = 20;
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IChromatogramEditorSupport chromatogramEditorSupport = PageChromatogram.this.getChromatogramEditorSupport(PageChromatogram.this.file);
                if (chromatogramEditorSupport != null) {
                    EModelService eModelService = ModelSupportAddon.getModelService();
                    MApplication mApplication = ModelSupportAddon.getApplication();
                    EPartService ePartService = ModelSupportAddon.getPartService();
                    chromatogramEditorSupport.openEditor(PageChromatogram.this.file, eModelService, mApplication, ePartService);
                }
            }
        });
        return imageHyperlink;
    }

    private IChromatogramEditorSupport getChromatogramEditorSupport(File file) {
        if (this.magicNumberMatcherMSD.checkFileFormat(file)) {
            return ChromatogramSupport.getInstanceEditorSupport();
        }
        if (this.magicNumberMatcherCSD.checkFileFormat(file)) {
            return org.eclipse.chemclipse.ux.extension.csd.ui.support.ChromatogramSupport.getInstanceEditorSupport();
        }
        if (this.magicNumberMatcherWSD.checkFileFormat(file)) {
            return org.eclipse.chemclipse.ux.extension.wsd.ui.support.ChromatogramSupport.getInstanceEditorSupport();
        }
        return null;
    }

    private IChromatogramOverview getChromatogramOverview(File file) {
        org.eclipse.chemclipse.msd.converter.supplier.chemclipse.converter.ChromatogramImportConverter importConverter = null;
        if (this.magicNumberMatcherMSD.checkFileFormat(file)) {
            importConverter = new org.eclipse.chemclipse.msd.converter.supplier.chemclipse.converter.ChromatogramImportConverter();
        } else if (this.magicNumberMatcherCSD.checkFileFormat(file)) {
            importConverter = new ChromatogramImportConverter();
        } else if (this.magicNumberMatcherWSD.checkFileFormat(file)) {
            importConverter = new org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.converter.ChromatogramImportConverter();
        }
        if (importConverter != null) {
            IChromatogramOverviewImportConverterProcessingInfo processingInfo = importConverter.convertOverview(file, (IProgressMonitor)new NullProgressMonitor());
            return processingInfo.getChromatogramOverview();
        }
        return null;
    }
}

