/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.massbank.converter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.massspectrum.AbstractMassSpectrumImportConverter;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.IMassSpectrumImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.MassSpectrumImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.massbank.internal.converter.SpecificationValidator;
import org.eclipse.chemclipse.msd.converter.supplier.massbank.io.MassBankReader;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassBankImportConverter
extends AbstractMassSpectrumImportConverter {
    private static final Logger logger = Logger.getLogger(MassBankImportConverter.class);
    private static final String DESCRIPTION = "MassBank MassSpectrum Import";

    public IMassSpectrumImportConverterProcessingInfo convert(File file, IProgressMonitor monitor) {
        MassSpectrumImportConverterProcessingInfo processingInfo = new MassSpectrumImportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                file = SpecificationValidator.validateSpecification(file);
                MassBankReader massSpectraReader = new MassBankReader();
                IMassSpectra massSpectra = massSpectraReader.read(file, monitor);
                processingInfo.setMassSpectra(massSpectra);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotReadableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not readable: " + file.getAbsolutePath());
            }
            catch (FileIsEmptyException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is empty: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

