/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.alignment.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.alignment.model.core.IRetentionIndex;
import org.eclipse.chemclipse.chromatogram.alignment.model.core.IRetentionIndices;
import org.eclipse.chemclipse.chromatogram.alignment.model.core.RetentionIndexComparator;
import org.eclipse.chemclipse.chromatogram.alignment.model.exceptions.NoRetentionIndexAvailableException;
import org.eclipse.chemclipse.chromatogram.alignment.model.exceptions.RetentionIndexExistsException;
import org.eclipse.chemclipse.chromatogram.alignment.model.exceptions.RetentionIndexValueException;

public class RetentionIndices
implements IRetentionIndices {
    private List<IRetentionIndex> retentionIndices = new ArrayList<IRetentionIndex>(10);
    private int actualRetentionIndex = 1;
    private RetentionIndexComparator retentionIndexComparator = new RetentionIndexComparator();

    @Override
    public void addRetentionIndex(IRetentionIndex retentionIndex) throws RetentionIndexExistsException, RetentionIndexValueException {
        this.checkRetentionIndexExists(retentionIndex);
        this.checkRetentionIndexSortOrder(retentionIndex);
        this.retentionIndices.add(retentionIndex);
        Collections.sort(this.retentionIndices, this.retentionIndexComparator);
        this.actualRetentionIndex = this.getRetentionIndexEntry(retentionIndex);
    }

    private void checkRetentionIndexExists(IRetentionIndex retentionIndex) throws RetentionIndexExistsException {
        for (IRetentionIndex ri : this.retentionIndices) {
            if (!retentionIndex.equals(ri)) continue;
            throw new RetentionIndexExistsException();
        }
    }

    private void checkRetentionIndexSortOrder(IRetentionIndex retentionIndex) throws RetentionIndexValueException {
        int previousRetentionTime = this.calculatePreviousRetentionTime(retentionIndex);
        int nextRetentionTime = this.calculateNextRetentionTime(retentionIndex);
        if (retentionIndex.getRetentionTime() <= previousRetentionTime || retentionIndex.getRetentionTime() >= nextRetentionTime) {
            throw new RetentionIndexValueException();
        }
    }

    private int calculatePreviousRetentionTime(IRetentionIndex retentionIndex) {
        int previousRetentionTime = 0;
        if (this.retentionIndices.size() > 1) {
            try {
                IRetentionIndex previous = this.getPreviousRetentionIndex(retentionIndex.getIndex());
                previousRetentionTime = previous.getRetentionTime();
            }
            catch (NoRetentionIndexAvailableException e) {
                previousRetentionTime = 0;
            }
        } else {
            try {
                IRetentionIndex previous = this.getRetentionIndex(1);
                previousRetentionTime = retentionIndex.getRetentionTime() > previous.getRetentionTime() ? previous.getRetentionTime() : 0;
            }
            catch (NoRetentionIndexAvailableException e) {
                previousRetentionTime = 0;
            }
        }
        return previousRetentionTime;
    }

    private int calculateNextRetentionTime(IRetentionIndex retentionIndex) {
        int nextRetentionTime = 0;
        if (this.retentionIndices.size() > 1) {
            try {
                IRetentionIndex next = this.getNextRetentionIndex(retentionIndex.getIndex());
                nextRetentionTime = next.getRetentionTime();
            }
            catch (NoRetentionIndexAvailableException e) {
                nextRetentionTime = Integer.MAX_VALUE;
            }
        } else {
            try {
                IRetentionIndex next = this.getRetentionIndex(1);
                nextRetentionTime = retentionIndex.getRetentionTime() > next.getRetentionTime() ? Integer.MAX_VALUE : next.getRetentionTime();
            }
            catch (NoRetentionIndexAvailableException e) {
                nextRetentionTime = Integer.MAX_VALUE;
            }
        }
        return nextRetentionTime;
    }

    @Override
    public IRetentionIndex getActualRetentionIndex() throws NoRetentionIndexAvailableException {
        return this.getRetentionIndex(this.actualRetentionIndex);
    }

    @Override
    public IRetentionIndex getFirstRetentionIndex() throws NoRetentionIndexAvailableException {
        return this.getRetentionIndex(1);
    }

    @Override
    public IRetentionIndex getLastRetentionIndex() throws NoRetentionIndexAvailableException {
        return this.getRetentionIndex(this.retentionIndices.size());
    }

    @Override
    public IRetentionIndex getPreviousRetentionIndex() throws NoRetentionIndexAvailableException {
        int previousIndex = this.actualRetentionIndex;
        return this.getRetentionIndex(--previousIndex);
    }

    @Override
    public IRetentionIndex getNextRetentionIndex() throws NoRetentionIndexAvailableException {
        int nextIndex = this.actualRetentionIndex;
        return this.getRetentionIndex(++nextIndex);
    }

    private IRetentionIndex getRetentionIndex(int entry) throws NoRetentionIndexAvailableException {
        int position = entry;
        if (entry < 1) {
            throw new NoRetentionIndexAvailableException();
        }
        if (this.retentionIndices.size() > 0 && entry <= this.retentionIndices.size()) {
            this.actualRetentionIndex = entry;
            return this.retentionIndices.get(--position);
        }
        throw new NoRetentionIndexAvailableException();
    }

    public int getRetentionIndexEntry(IRetentionIndex retentionIndex) {
        int index = 1;
        int i = 1;
        while (i <= this.retentionIndices.size()) {
            IRetentionIndex actIndex;
            try {
                actIndex = this.getRetentionIndex(i);
            }
            catch (NoRetentionIndexAvailableException e) {
                break;
            }
            if (retentionIndex.getIndex() == actIndex.getIndex()) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    @Override
    public IRetentionIndex getPreviousRetentionIndex(float index) throws NoRetentionIndexAvailableException {
        int i = 1;
        while (i <= this.retentionIndices.size()) {
            IRetentionIndex actIndex = this.getRetentionIndex(i);
            if (actIndex.getIndex() >= index) {
                if (i == 1) {
                    throw new NoRetentionIndexAvailableException();
                }
                return this.getRetentionIndex(--i);
            }
            ++i;
        }
        throw new NoRetentionIndexAvailableException();
    }

    @Override
    public IRetentionIndex getPreviousRetentionIndex(int retentionTime) throws NoRetentionIndexAvailableException {
        int i = 1;
        while (i <= this.retentionIndices.size()) {
            IRetentionIndex actIndex = this.getRetentionIndex(i);
            if (actIndex.getRetentionTime() >= retentionTime) {
                if (i == 1) {
                    throw new NoRetentionIndexAvailableException();
                }
                return this.getRetentionIndex(--i);
            }
            ++i;
        }
        throw new NoRetentionIndexAvailableException();
    }

    @Override
    public IRetentionIndex getNextRetentionIndex(float index) throws NoRetentionIndexAvailableException {
        int i = this.retentionIndices.size();
        while (i >= 1) {
            IRetentionIndex actIndex = this.getRetentionIndex(i);
            if (actIndex.getIndex() <= index) {
                if (i == this.retentionIndices.size()) {
                    throw new NoRetentionIndexAvailableException();
                }
                return this.getRetentionIndex(++i);
            }
            --i;
        }
        throw new NoRetentionIndexAvailableException();
    }

    @Override
    public IRetentionIndex getNextRetentionIndex(int retentionTime) throws NoRetentionIndexAvailableException {
        int i = this.retentionIndices.size();
        while (i >= 1) {
            IRetentionIndex actIndex = this.getRetentionIndex(i);
            if (actIndex.getRetentionTime() <= retentionTime) {
                if (i == this.retentionIndices.size()) {
                    throw new NoRetentionIndexAvailableException();
                }
                return this.getRetentionIndex(++i);
            }
            --i;
        }
        throw new NoRetentionIndexAvailableException();
    }

    @Override
    public void removeRetentionIndex(float index) {
        int i = 0;
        for (IRetentionIndex ri : this.retentionIndices) {
            ++i;
            if (ri.getIndex() != index) continue;
            this.retentionIndices.remove(ri);
            this.setActualRetentionIndex(i);
            break;
        }
    }

    @Override
    public void removeRetentionIndex(int retentionTime) {
        int i = 0;
        for (IRetentionIndex ri : this.retentionIndices) {
            ++i;
            if (ri.getRetentionTime() != retentionTime) continue;
            this.retentionIndices.remove(ri);
            this.setActualRetentionIndex(i);
            break;
        }
    }

    @Override
    public void removeRetentionIndex(IRetentionIndex retentionIndex) {
        int i = 0;
        for (IRetentionIndex ri : this.retentionIndices) {
            ++i;
            if (!ri.equals(retentionIndex)) continue;
            this.retentionIndices.remove(ri);
            this.setActualRetentionIndex(i);
            break;
        }
    }

    @Override
    public void removeRetentionIndex(String name) {
        int i = 1;
        for (IRetentionIndex ri : this.retentionIndices) {
            if (ri.getName().equals(name)) {
                this.retentionIndices.remove(ri);
                this.setActualRetentionIndex(i);
                break;
            }
            ++i;
        }
    }

    private void setActualRetentionIndex(int index) {
        int position = index;
        this.actualRetentionIndex = index == 1 ? position : --position;
    }
}

