/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.distance.comparator;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.AbstractMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.LazyComparisonResult;
import org.eclipse.chemclipse.model.identifier.MatchConstraints;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;

public class CosineMassSpectrumComparator
extends AbstractMassSpectrumComparator
implements IMassSpectrumComparator {
    public IProcessingInfo<IComparisonResult> compare(IScanMSD unknown, IScanMSD reference, MatchConstraints matchConstraints) {
        IProcessingInfo processingInfo = super.validate(unknown, reference);
        if (!processingInfo.hasErrorMessages()) {
            IExtractedIonSignal unknownSignal = unknown.getExtractedIonSignal();
            IExtractedIonSignal referenceSignal = reference.getExtractedIonSignal();
            LazyComparisonResult massSpectrumComparisonResult = new LazyComparisonResult(() -> this.calculateCosinePhi(unknownSignal, referenceSignal), () -> this.calculateCosinePhi(referenceSignal, unknownSignal), () -> this.calculateCosinePhiDirect(unknownSignal, referenceSignal), () -> this.calculateCosinePhiDirect(referenceSignal, unknownSignal), matchConstraints);
            processingInfo.setProcessingResult((Object)massSpectrumComparisonResult);
        }
        return processingInfo;
    }

    public double calculateCosinePhi(IExtractedIonSignal unknownSignal, IExtractedIonSignal referenceSignal) {
        int size = unknownSignal.getNumberOfIonValues();
        double[] unknown = new double[size];
        double[] reference = new double[size];
        int i = unknownSignal.getStartIon();
        int j = 0;
        while (i <= unknownSignal.getStopIon()) {
            unknown[j] = this.getVectorValue(unknownSignal, i);
            reference[j] = this.getVectorValue(referenceSignal, i);
            ++i;
            ++j;
        }
        ArrayRealVector unknownVector = new ArrayRealVector(unknown);
        ArrayRealVector referenceVector = new ArrayRealVector(reference);
        try {
            return unknownVector.cosine((RealVector)referenceVector) * 100.0;
        }
        catch (DimensionMismatchException | MathArithmeticException e) {
            return 0.0;
        }
    }

    public double calculateCosinePhiDirect(IExtractedIonSignal unknownSignal, IExtractedIonSignal referenceSignal) {
        ArrayList<Integer> ionList = new ArrayList<Integer>();
        int startIon = unknownSignal.getStartIon();
        int stopIon = unknownSignal.getStopIon();
        int ion = startIon;
        while (ion <= stopIon) {
            if (unknownSignal.getAbundance(ion) > 0.0f) {
                ionList.add(ion);
            }
            ++ion;
        }
        double[] unknown = new double[ionList.size()];
        double[] reference = new double[ionList.size()];
        int j = 0;
        Iterator iterator = ionList.iterator();
        while (iterator.hasNext()) {
            int ion2 = (Integer)iterator.next();
            unknown[j] = unknownSignal.getAbundance(ion2);
            reference[j] = referenceSignal.getAbundance(ion2);
            ++j;
        }
        ArrayRealVector unknownVector = new ArrayRealVector(unknown);
        ArrayRealVector referenceVector = new ArrayRealVector(reference);
        try {
            return unknownVector.cosine((RealVector)referenceVector) * 100.0;
        }
        catch (DimensionMismatchException | MathArithmeticException e) {
            return 0.0;
        }
    }

    protected double getVectorValue(IExtractedIonSignal signal, int i) {
        return signal.getAbundance(i);
    }
}

