/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.runnables;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.MassSpectrumIdentifier;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class MassSpectraIdentifierRunnable
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "File Mass Spectrum Identifier";
    private static final String IDENTIFIER_ID = "org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.massSpectrum";
    private IChromatogramSelectionMSD chromatogramSelection;

    public MassSpectraIdentifierRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
            IChromatogramMSD chromtogramMSD = this.chromatogramSelection.getChromatogramMSD();
            int startScan = chromtogramMSD.getScanNumber(this.chromatogramSelection.getStartRetentionTime());
            int stopScan = chromtogramMSD.getScanNumber(this.chromatogramSelection.getStopRetentionTime());
            int i = startScan;
            while (i <= stopScan) {
                IScanMSD scanMSD;
                IScan scan = chromtogramMSD.getScan(i);
                if (scan instanceof IScanMSD && (scanMSD = (IScanMSD)scan).getTargets().size() > 0) {
                    massSpectra.add(scanMSD);
                }
                ++i;
            }
            IProcessingInfo processingInfo = MassSpectrumIdentifier.identify(massSpectra, (String)IDENTIFIER_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
        }
        finally {
            monitor.done();
        }
    }
}

