/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram.ChromatogramIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram.IChromatogramIdentifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram.IChromatogramIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IChromatogramIdentifierSettings;
import org.eclipse.chemclipse.model.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ChromatogramIdentifierProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Chromatogram Identifier";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            ArrayList list = new ArrayList();
            IChromatogramIdentifierSupport support = ChromatogramIdentifier.getChromatogramIdentifierSupport();
            for (String processorId : support.getAvailableIdentifierIds()) {
                IChromatogramIdentifierSupplier supplier = support.getIdentifierSupplier(processorId);
                list.add((IProcessSupplier<?>)new ChromatogramIdentifierProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoIdentifierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class ChromatogramIdentifierProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IChromatogramIdentifierSettings> {
        public ChromatogramIdentifierProcessorSupplier(IChromatogramIdentifierSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getIdentifierName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramIdentifierSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                if (processSettings == null) {
                    messageConsumer.addMessages((MessageProvider)ChromatogramIdentifier.identify(chromatogramSelectionMSD, this.getId(), monitor));
                } else {
                    messageConsumer.addMessages((MessageProvider)ChromatogramIdentifier.identify(chromatogramSelectionMSD, processSettings, this.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getName(), "Only MSD chromatograms are supported, processor was skipped");
            }
            return chromatogramSelection;
        }
    }
}

