/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.runnables;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.io.PeakIdentificationBatchJobReader;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class BatchJobImportRunnable
implements IRunnableWithProgress {
    private File file;
    private IPeakIdentificationBatchJob peakIdentificationBatchJob = null;

    public BatchJobImportRunnable(File file) {
        this.file = file;
    }

    public IPeakIdentificationBatchJob getPeakIdentificationBatchJob() {
        return this.peakIdentificationBatchJob;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        PeakIdentificationBatchJobReader reader = new PeakIdentificationBatchJobReader();
        try {
            this.peakIdentificationBatchJob = reader.read(this.file, monitor);
        }
        catch (FileNotFoundException e) {
            throw new InterruptedException("The file " + this.file.getPath() + " couldn't be found.");
        }
        catch (FileIsNotReadableException e) {
            throw new InterruptedException("The file " + this.file.getPath() + " is not readable.");
        }
        catch (FileIsEmptyException e) {
            throw new InterruptedException("The file " + this.file.getPath() + " is empty.");
        }
        catch (IOException e) {
            throw new InterruptedException("An I/O error has occured using the file " + this.file.getPath());
        }
    }
}

