/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.io.DatabaseSupport;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.AddPeaksPageESTD;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.QuantitationCompoundSupport;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AddPeaksWizardESTD
extends Wizard {
    private static final Logger logger = Logger.getLogger(AddPeaksWizardESTD.class);
    private AddPeaksPageESTD page;
    private List<IPeak> peaks;

    public AddPeaksWizardESTD(List<IPeak> peaks) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Add Peaks (ESTD)");
        this.peaks = peaks;
    }

    public void addPages() {
        this.page = new AddPeaksPageESTD("PeakPageESTD");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.removeErrorMessage();
        double concentration = this.page.getConcentration();
        String concentrationUnit = this.page.getConcentrationUnit();
        if (this.peaks == null || this.peaks.size() == 0) {
            this.showErrorMessage("There is no peak list available.");
            return false;
        }
        if (concentrationUnit == null || concentrationUnit.equals("")) {
            this.showErrorMessage("Please select a concentration unit for compounds that will be created.");
            return false;
        }
        if (concentration < 0.0) {
            this.showErrorMessage("Please select a valid concentration.");
            return false;
        }
        DatabaseSupport databaseSupport = new DatabaseSupport();
        IQuantitationDatabase quantitationDatabase = databaseSupport.load();
        if (quantitationDatabase != null && quantitationDatabase.size() >= 0) {
            for (IPeak peak : this.peaks) {
                String name = this.getPeakTargetName(peak);
                if (name == null) {
                    logger.warn((Object)("The peak has no target. It has been not added to the quantitation database: " + peak));
                    continue;
                }
                if (!(peak instanceof IPeakMSD)) continue;
                QuantitationCompoundSupport quantitationCompoundSupport = new QuantitationCompoundSupport();
                if (quantitationDatabase.containsQuantitationCompund(name)) {
                    quantitationCompoundSupport.merge(quantitationDatabase, peak, name, concentration);
                    continue;
                }
                String chemicalClass = this.page.getChemicalClass();
                IQuantitationCompound quantitationCompound = quantitationCompoundSupport.create(peak, name, concentration, concentrationUnit, chemicalClass);
                quantitationDatabase.add((Object)quantitationCompound);
            }
            databaseSupport.save(quantitationDatabase);
            return true;
        }
        this.showErrorMessage("Please select a quantitation table previously.");
        return false;
    }

    private String getPeakTargetName(IPeak peak) {
        Set peakTargets;
        ILibraryInformation libraryInformation = null;
        float bestMatchFactor = 0.0f;
        if (peak != null && (peakTargets = peak.getTargets()).size() > 0) {
            for (IIdentificationTarget peakTarget : peakTargets) {
                IIdentificationTarget peakIdentificationEntry;
                float actualMatchFactor;
                if (!(peakTarget instanceof IIdentificationTarget) || !((actualMatchFactor = (peakIdentificationEntry = peakTarget).getComparisonResult().getMatchFactor()) > bestMatchFactor)) continue;
                bestMatchFactor = actualMatchFactor;
                libraryInformation = peakIdentificationEntry.getLibraryInformation();
            }
        }
        if (libraryInformation == null) {
            return null;
        }
        return libraryInformation.getName();
    }

    private void showErrorMessage(String message) {
        this.page.setErrorMessage(message);
    }

    private void removeErrorMessage() {
        this.page.setErrorMessage(null);
    }
}

