/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.supplier.tic.core;

import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.AbstractBaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.supplier.tic.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.supplier.tic.settings.DetectorSettings;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineDetector
extends AbstractBaselineDetector {
    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(chromatogramSelection, baselineDetectorSettings, monitor);
        if (!processingInfo.hasErrorMessages() && baselineDetectorSettings instanceof DetectorSettings) {
            this.calculateBaseline(chromatogramSelection);
        }
        return processingInfo;
    }

    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        DetectorSettings detectorSettings = PreferenceSupplier.getDetectorSettings();
        return this.setBaseline(chromatogramSelection, (IBaselineDetectorSettings)detectorSettings, monitor);
    }

    private void calculateBaseline(IChromatogramSelection chromatogramSelection) {
        int stopScan;
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        float lowestTIC = this.getLowestTIC(chromatogram, startScan, stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime()));
        if (lowestTIC > 0.0f) {
            float backgroundAbundance = lowestTIC >= 1.0f ? lowestTIC - 1.0f : lowestTIC - Float.MIN_VALUE;
            int i = startScan;
            while (i < stopScan) {
                IScan scan = chromatogram.getScan(i);
                IScan scanNext = chromatogram.getScan(i + 1);
                int startRetentionTime = scan.getRetentionTime();
                int stopRetentionTime = scanNext.getRetentionTime();
                baselineModel.addBaseline(startRetentionTime, stopRetentionTime, backgroundAbundance, backgroundAbundance, true);
                ++i;
            }
        }
    }

    private float getLowestTIC(IChromatogram chromatogram, int startScan, int stopScan) {
        float lowestTIC = Float.MAX_VALUE;
        int i = startScan;
        while (i <= stopScan) {
            IScan scan = chromatogram.getScan(i);
            float totalSignal = scan.getTotalSignal();
            if (totalSignal < lowestTIC) {
                lowestTIC = totalSignal;
            }
            ++i;
        }
        return lowestTIC;
    }
}

