/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.core;

import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.AbstractChromatogramCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.settings.IChromatogramCalculatorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.RetentionIndexCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.settings.CalculatorSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramCalculator
extends AbstractChromatogramCalculator {
    public IProcessingInfo applyCalculator(IChromatogramSelection chromatogramSelection, IChromatogramCalculatorSettings chromatogramCalculatorSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = null;
        if (chromatogramCalculatorSettings instanceof CalculatorSettings) {
            CalculatorSettings calculatorSettings = (CalculatorSettings)chromatogramCalculatorSettings;
            RetentionIndexCalculator calculator = new RetentionIndexCalculator();
            processingInfo = calculator.apply(chromatogramSelection, calculatorSettings, monitor);
        }
        if (processingInfo == null) {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage("RI Calculator", "Something went wrong.");
        }
        return processingInfo;
    }

    public IProcessingInfo applyCalculator(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        CalculatorSettings calculatorSettings = PreferenceSupplier.getChromatogramCalculatorSettings();
        return this.applyCalculator(chromatogramSelection, (IChromatogramCalculatorSettings)calculatorSettings, monitor);
    }
}

