/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IIdentifierSettingsMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettingsMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core.MassSpectrumIdentifierFile;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core.PeakIdentifierFile;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.IFileIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.DatabasesCache;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.PathResolver;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.IPeakIdentificationResults;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.support.util.FileListUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class AlkaneIdentifier {
    public static final String IDENTIFIER = "Alkane Identifier";
    private static final String MASS_SPECTRUM_COMPARATOR_ID = "org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.incos";
    private final String massSpectraFiles;
    private final DatabasesCache databasesCache;

    public AlkaneIdentifier() {
        FileListUtil fileListUtil = new FileListUtil();
        this.massSpectraFiles = AlkaneIdentifier.getDatabase();
        this.databasesCache = new DatabasesCache(fileListUtil.getFiles(this.massSpectraFiles));
    }

    public static String getDatabase() {
        return PathResolver.getAbsolutePath("standards/alkanes.msl");
    }

    public IProcessingInfo<IPeakIdentificationResults> runPeakIdentification(List<? extends IPeakMSD> peaks, IProgressMonitor monitor) throws FileNotFoundException {
        PeakIdentifierSettings peakIdentifierSettings = new PeakIdentifierSettings();
        this.setIdentifierSettings((IIdentifierSettingsMSD)peakIdentifierSettings);
        this.setFileIdentifierSettings((IFileIdentifierSettings)peakIdentifierSettings);
        PeakIdentifierFile peakIdentifier = new PeakIdentifierFile();
        return peakIdentifier.identify(peaks, (IPeakIdentifierSettingsMSD)peakIdentifierSettings, monitor);
    }

    public IProcessingInfo<IMassSpectra> runIdentification(List<IScanMSD> massSpectraList, IMassSpectrumIdentifierSettings fileIdentifierSettings, IProgressMonitor monitor) throws FileNotFoundException {
        MassSpectrumIdentifierSettings massSpectrumIdentifierSettings = new MassSpectrumIdentifierSettings();
        this.setIdentifierSettings((IIdentifierSettingsMSD)massSpectrumIdentifierSettings);
        this.setFileIdentifierSettings((IFileIdentifierSettings)massSpectrumIdentifierSettings);
        MassSpectrumIdentifierFile peakIdentifier = new MassSpectrumIdentifierFile();
        return peakIdentifier.identify(massSpectraList, (IMassSpectrumIdentifierSettings)massSpectrumIdentifierSettings, monitor);
    }

    public IMassSpectra getMassSpectra(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        MassSpectra massSpectra = new MassSpectra();
        if (this.isValid(identificationTarget)) {
            massSpectra.addMassSpectra((Collection)this.databasesCache.getDatabaseMassSpectra(identificationTarget, monitor));
        }
        return massSpectra;
    }

    public DatabasesCache getDatabasesCache() {
        return this.databasesCache;
    }

    public boolean isValid(IIdentificationTarget identificationTarget) {
        if (identificationTarget != null) {
            return identificationTarget.getIdentifier().equals(IDENTIFIER);
        }
        return false;
    }

    private void setIdentifierSettings(IIdentifierSettingsMSD identifierSettings) {
        identifierSettings.setMassSpectrumComparatorId(MASS_SPECTRUM_COMPARATOR_ID);
        identifierSettings.setPenaltyCalculation("NONE");
        identifierSettings.setPenaltyCalculationLevelFactor(0.0f);
        identifierSettings.setMaxPenalty(0.0f);
        identifierSettings.setRetentionTimeWindow(0);
        identifierSettings.setRetentionIndexWindow(0.0f);
    }

    private void setFileIdentifierSettings(IFileIdentifierSettings fileIdentifierSettings) {
        fileIdentifierSettings.setMassSpectraFiles(this.massSpectraFiles);
        fileIdentifierSettings.setUsePreOptimization(false);
        fileIdentifierSettings.setThresholdPreOptimization(0.1);
        fileIdentifierSettings.setNumberOfTargets(PreferenceSupplier.getNumberOfTargets());
        fileIdentifierSettings.setMinMatchFactor(PreferenceSupplier.getMinMatchFactor());
        fileIdentifierSettings.setMinReverseMatchFactor(PreferenceSupplier.getMinReverseMatchFactor());
        fileIdentifierSettings.setAlternateIdentifierId(IDENTIFIER);
    }
}

