/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.settings.IPeakDetectorSettingsCSD;
import org.eclipse.chemclipse.chromatogram.peak.detector.model.Threshold;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.RetentionIndexCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.settings.CalculatorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.AreaSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IIntegrationSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.core.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.settings.PeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.PeakDetectorCSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.PeakDetectorSettingsCSD;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class AlkanePatternDetectorCSD {
    private static final Logger logger = Logger.getLogger(AlkanePatternDetectorCSD.class);

    public IChromatogramCSD parseChromatogram(String chromatogramPath, String pathRetentionIndexFile, boolean useAlreadyDetectedPeaks, IProgressMonitor monitor) {
        IChromatogramCSD chromatogramCSD = null;
        try {
            File file = new File(chromatogramPath);
            IProcessingInfo processingInfo = ChromatogramConverterCSD.getInstance().convert(file, monitor);
            chromatogramCSD = (IChromatogramCSD)processingInfo.getProcessingResult();
            ChromatogramSelectionCSD chromatogramSelectionCSD = new ChromatogramSelectionCSD(chromatogramCSD);
            if (!useAlreadyDetectedPeaks) {
                PeakDetectorCSD peakDetectorCSD = new PeakDetectorCSD();
                PeakDetectorSettingsCSD peakDetectorSettings = new PeakDetectorSettingsCSD();
                peakDetectorSettings.setThreshold(Threshold.LOW);
                peakDetectorSettings.setIncludeBackground(false);
                peakDetectorSettings.setMinimumSignalToNoiseRatio(50.0f);
                peakDetectorSettings.setMovingAverageWindowSize(WindowSize.WIDTH_5);
                peakDetectorCSD.detect((IChromatogramSelectionCSD)chromatogramSelectionCSD, (IPeakDetectorSettingsCSD)peakDetectorSettings, monitor);
                PeakIntegrator peakIntegrator = new PeakIntegrator();
                PeakIntegrationSettings peakIntegratorSettings = new PeakIntegrationSettings();
                peakIntegratorSettings.setIncludeBackground(false);
                AreaSupport areaSupport = new AreaSupport();
                areaSupport.setMinimumArea(0.0);
                IIntegrationSupport integrationSupport = peakIntegratorSettings.getIntegrationSupport();
                integrationSupport.setMinimumPeakWidth(0);
                integrationSupport.setMinimumSignalToNoiseRatio(0.0f);
                peakIntegratorSettings.getSelectedIons().clear();
                peakIntegrator.integrate((IChromatogramSelection)chromatogramSelectionCSD, monitor);
            }
            if (!"".equals(pathRetentionIndexFile)) {
                RetentionIndexCalculator retentionIndexCalculator = new RetentionIndexCalculator();
                CalculatorSettings calculatorSettings = new CalculatorSettings();
                ArrayList<String> retentionIndexFiles = new ArrayList<String>();
                retentionIndexFiles.add(pathRetentionIndexFile);
                calculatorSettings.setRetentionIndexFiles(retentionIndexFiles);
                retentionIndexCalculator.apply((IChromatogramSelection)chromatogramSelectionCSD, calculatorSettings, monitor);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return chromatogramCSD;
    }
}

