/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.CalibrationFileReader;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.settings.CalculatorSettings;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class RetentionIndexCalculator {
    public IProcessingInfo apply(IChromatogramSelection chromatogramSelection, CalculatorSettings calculatorSettings, IProgressMonitor monitor) {
        ISeparationColumnIndices separationColumnIndices;
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramSelection != null && (separationColumnIndices = this.getSeparationColumnIndices(chromatogramSelection, calculatorSettings)) != null) {
            this.calculateIndex(chromatogramSelection, separationColumnIndices);
            if (PreferenceSupplier.isProcessReferencedChromatograms()) {
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                for (Object object : chromatogram.getReferencedChromatograms()) {
                    IChromatogramSelection chromatogramSelectionReference = this.getChromatogramSelection(object);
                    if (chromatogramSelectionReference == null) continue;
                    this.calculateIndex(chromatogramSelectionReference, separationColumnIndices);
                }
            }
        }
        return processingInfo;
    }

    private ISeparationColumnIndices getSeparationColumnIndices(IChromatogramSelection chromatogramSelection, CalculatorSettings calculatorSettings) {
        ISeparationColumnIndices separationColumnIndices;
        switch (PreferenceSupplier.getDetectionStrategy()) {
            case "Automatic": {
                separationColumnIndices = this.getAutoIndices(chromatogramSelection, calculatorSettings);
                break;
            }
            case "Chromatogram": {
                separationColumnIndices = this.getChromatogramIndices(chromatogramSelection);
                break;
            }
            case "Files": {
                separationColumnIndices = this.getFileIndices(chromatogramSelection, calculatorSettings);
                break;
            }
            default: {
                separationColumnIndices = null;
            }
        }
        return separationColumnIndices;
    }

    private ISeparationColumnIndices getAutoIndices(IChromatogramSelection chromatogramSelection, CalculatorSettings calculatorSettings) {
        ISeparationColumnIndices separationColumnIndices = this.getChromatogramIndices(chromatogramSelection);
        if (separationColumnIndices == null) {
            separationColumnIndices = this.getFileIndices(chromatogramSelection, calculatorSettings);
        } else if (separationColumnIndices.size() == 0) {
            separationColumnIndices = this.getFileIndices(chromatogramSelection, calculatorSettings);
        }
        return separationColumnIndices;
    }

    private ISeparationColumnIndices getChromatogramIndices(IChromatogramSelection chromatogramSelection) {
        if (chromatogramSelection != null) {
            return chromatogramSelection.getChromatogram().getSeparationColumnIndices();
        }
        return null;
    }

    private ISeparationColumnIndices getFileIndices(IChromatogramSelection chromatogramSelection, CalculatorSettings calculatorSettings) {
        List<String> retentionIndexFiles = calculatorSettings.getRetentionIndexFiles();
        CalibrationFileReader calibrationFileReader = new CalibrationFileReader();
        HashMap<String, ISeparationColumnIndices> calibrationMap = new HashMap<String, ISeparationColumnIndices>();
        for (String retentionIndexFile : retentionIndexFiles) {
            File file = new File(retentionIndexFile);
            ISeparationColumnIndices separationColumnIndices = calibrationFileReader.parse(file);
            ISeparationColumn separationColumn = separationColumnIndices.getSeparationColumn();
            calibrationMap.put(separationColumn.getName(), separationColumnIndices);
        }
        String columnName = chromatogramSelection.getChromatogram().getSeparationColumnIndices().getSeparationColumn().getName();
        ISeparationColumnIndices separationColumnIndices = (ISeparationColumnIndices)calibrationMap.get(columnName);
        if (separationColumnIndices == null && PreferenceSupplier.isUseDefaultColumn()) {
            separationColumnIndices = (ISeparationColumnIndices)calibrationMap.get("DEFAULT");
        }
        return separationColumnIndices;
    }

    public float calculateRetentionIndex(int retentionTime, ISeparationColumnIndices separationColumnIndices) {
        float retentionIndex = 0.0f;
        Map.Entry floorEntry = separationColumnIndices.floorEntry((Object)retentionTime);
        Map.Entry ceilingEntry = separationColumnIndices.ceilingEntry((Object)retentionTime);
        if (floorEntry != null && ceilingEntry != null) {
            IRetentionIndexEntry floorIndex = (IRetentionIndexEntry)floorEntry.getValue();
            IRetentionIndexEntry ceilingIndex = (IRetentionIndexEntry)ceilingEntry.getValue();
            float retentionIndexLow = floorIndex.getRetentionIndex();
            int retentionTimeLow = floorIndex.getRetentionTime();
            float retentionIndexHigh = ceilingIndex.getRetentionIndex();
            int retentionTimeHigh = ceilingIndex.getRetentionTime();
            retentionIndex = this.calculateRetentionIndex(retentionTime, retentionTimeLow, retentionTimeHigh, retentionIndexLow, retentionIndexHigh);
        }
        return retentionIndex;
    }

    public float calculateRetentionIndex(int retentionTime, int retentionTimeLow, int retentionTimeHigh, float retentionIndexLow, float retentionIndexHigh) {
        float retentionIndex = 0.0f;
        if (retentionTimeLow == retentionTimeHigh) {
            return retentionIndexLow;
        }
        float factorRetentionIndex = retentionIndexHigh - retentionIndexLow;
        float nominatorRT = retentionTime - retentionTimeLow;
        float denominatorRT = retentionTimeHigh - retentionTimeLow;
        if (denominatorRT != 0.0f) {
            retentionIndex = retentionIndexLow + factorRetentionIndex * nominatorRT / denominatorRT;
        }
        return retentionIndex;
    }

    private void calculateIndex(IChromatogramSelection chromatogramSelection, ISeparationColumnIndices separationColumnIndices) {
        if (separationColumnIndices != null) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            int startRetentionTime = chromatogramSelection.getStartRetentionTime();
            int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
            int startScan = chromatogram.getScanNumber(startRetentionTime);
            int stopScan = chromatogram.getScanNumber(stopRetentionTime);
            int scan = startScan;
            while (scan <= stopScan) {
                IScanMSD scanMSD;
                IScanMSD optimizedMassSpectrum;
                IScan supplierScan = chromatogram.getScan(scan);
                int retentionTime = supplierScan.getRetentionTime();
                float retentionIndex = this.calculateRetentionIndex(retentionTime, separationColumnIndices);
                supplierScan.setRetentionIndex(retentionIndex);
                if (supplierScan instanceof IScanMSD && (optimizedMassSpectrum = (scanMSD = (IScanMSD)supplierScan).getOptimizedMassSpectrum()) != null) {
                    optimizedMassSpectrum.setRetentionIndex(retentionIndex);
                }
                ++scan;
            }
            List peaks = chromatogram.getPeaks();
            for (IPeak peak : peaks) {
                IScan scan2 = peak.getPeakModel().getPeakMaximum();
                int retentionTime = scan2.getRetentionTime();
                if (retentionTime < startRetentionTime || retentionTime > stopRetentionTime) continue;
                float retentionIndex = this.calculateRetentionIndex(retentionTime, separationColumnIndices);
                scan2.setRetentionIndex(retentionIndex);
            }
        }
    }

    public IChromatogramSelection getChromatogramSelection(Object object) {
        if (object instanceof IChromatogramSelection) {
            return (IChromatogramSelection)object;
        }
        if (object instanceof IChromatogramCSD) {
            return new ChromatogramSelectionCSD((IChromatogramCSD)object);
        }
        if (object instanceof IChromatogramMSD) {
            return new ChromatogramSelectionMSD((IChromatogramMSD)object);
        }
        if (object instanceof IChromatogramWSD) {
            return new ChromatogramSelectionWSD((IChromatogramWSD)object);
        }
        return null;
    }
}

