/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.PathResolver;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.RetentionIndexEntry;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class StandardsReader {
    public IMassSpectra getStandardsMassSpectra() {
        File file = new File(PathResolver.getAbsolutePath("standards/alkanes.msl"));
        IProcessingInfo processingInfo = DatabaseConverter.convert((File)file, (IProgressMonitor)new NullProgressMonitor());
        IMassSpectra massSpectra = (IMassSpectra)processingInfo.getProcessingResult(IMassSpectra.class);
        return massSpectra;
    }

    public List<IRetentionIndexEntry> getStandardsList() {
        ArrayList<IRetentionIndexEntry> retentionIndexEntries = new ArrayList<IRetentionIndexEntry>();
        IMassSpectra massSpectra = this.getStandardsMassSpectra();
        for (IScanMSD massSpectrum : massSpectra.getList()) {
            if (!(massSpectrum instanceof ILibraryMassSpectrum)) continue;
            ILibraryMassSpectrum libraryMassSpectrum = (ILibraryMassSpectrum)massSpectrum;
            String name = libraryMassSpectrum.getLibraryInformation().getName();
            int retentionTime = massSpectrum.getRetentionTime();
            float retentionIndex = massSpectrum.getRetentionIndex();
            RetentionIndexEntry retentionIndexEntry = new RetentionIndexEntry(retentionTime, retentionIndex, name);
            retentionIndexEntries.add((IRetentionIndexEntry)retentionIndexEntry);
        }
        return retentionIndexEntries;
    }

    public Set<String> getStandardNames() {
        HashSet<String> standardNames = new HashSet<String>();
        List<IRetentionIndexEntry> retentionIndexEntries = this.getStandardsList();
        for (IRetentionIndexEntry retentionIndexEntry : retentionIndexEntries) {
            standardNames.add(retentionIndexEntry.getName());
        }
        return standardNames;
    }

    public String[] getAvailableStandards() {
        List<IRetentionIndexEntry> retentionIndexEntries = this.getStandardsList();
        int size = retentionIndexEntries.size();
        String[] entries = new String[size];
        int i = 0;
        while (i < size) {
            entries[i] = retentionIndexEntries.get(i).getName();
            ++i;
        }
        return entries;
    }

    public Map<String, Integer> getNameIndexMap() {
        HashMap<String, Integer> retentionIndices = new HashMap<String, Integer>();
        StandardsReader standardsReader = new StandardsReader();
        List<IRetentionIndexEntry> retentionIndexEntries = standardsReader.getStandardsList();
        for (IRetentionIndexEntry retentionIndexEntry : retentionIndexEntries) {
            retentionIndices.put(retentionIndexEntry.getName(), (int)retentionIndexEntry.getRetentionIndex());
        }
        return retentionIndices;
    }
}

