/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.AbstractChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.AbstractChromatogramClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.IChromatogramClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.settings.NoiseChromatogramClassifierSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.results.ChromatogramSegmentation;
import org.eclipse.chemclipse.model.results.NoiseSegmentMeasurementResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.NoiseSegment;
import org.eclipse.chemclipse.model.support.SegmentWidth;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class NoiseChromatogramClassifier
extends AbstractChromatogramClassifier {
    private static final String NAME = "Set Noise Settings";

    public NoiseChromatogramClassifier() {
        super(new DataType[]{DataType.MSD, DataType.WSD, DataType.CSD});
    }

    public IProcessingInfo<IChromatogramClassifierResult> applyClassifier(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramClassifierSettings chromatogramClassifierSettings, IProgressMonitor monitor) {
        NoiseChromatogramClassifierSettings settings;
        ProcessingInfo info = new ProcessingInfo((Object)new AbstractChromatogramClassifierResult(ResultStatus.OK, NAME){});
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        NoiseSegmentMeasurementResult noiseSettings = NoiseChromatogramClassifier.applyNoiseSettings(chromatogram, settings = chromatogramClassifierSettings instanceof NoiseChromatogramClassifierSettings ? (NoiseChromatogramClassifierSettings)chromatogramClassifierSettings : new NoiseChromatogramClassifierSettings(), monitor);
        if (noiseSettings == null) {
            info.addErrorMessage(NAME, "Can't find any noise segments in the given Chromatogram");
        } else if (noiseSettings.getSegmentation().getWidth() != settings.getSegmentWidth()) {
            info.addWarnMessage(NAME, "No noise segments found with segmentation width " + settings.getSegmentWidth() + " using value " + noiseSettings.getSegmentation().getWidth() + " instead, you might want to adjust settings to get better results");
        }
        return info;
    }

    private static NoiseSegmentMeasurementResult applyNoiseSettings(IChromatogram<?> chromatogram, NoiseChromatogramClassifierSettings settings, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        INoiseCalculator noiseCalculator = settings.getNoiseCalculator();
        if (noiseCalculator == null) {
            throw new IllegalArgumentException("noise calculator with id " + settings.getNoiseCalculatorId() + " not found");
        }
        SegmentWidth segmentWidth = settings.getSegmentWidth();
        do {
            ChromatogramSegmentation segmentation = new ChromatogramSegmentation(chromatogram, segmentWidth);
            chromatogram.addMeasurementResult((IMeasurementResult)segmentation);
            List<NoiseSegment> noiseSegments = noiseCalculator.getNoiseSegments(chromatogram, (IProgressMonitor)subMonitor.split(80));
            if (!noiseSegments.isEmpty()) {
                NoiseSegmentMeasurementResult result = new NoiseSegmentMeasurementResult(Collections.unmodifiableList(noiseSegments), segmentation, settings.getNoiseCalculatorId());
                for (IMeasurementResult oldresult : new ArrayList(chromatogram.getMeasurementResults())) {
                    if (!(oldresult instanceof NoiseSegmentMeasurementResult)) continue;
                    chromatogram.deleteMeasurementResult(oldresult.getIdentifier());
                }
                chromatogram.addMeasurementResult((IMeasurementResult)result);
                return result;
            }
            segmentWidth = SegmentWidth.getLower((SegmentWidth)segmentWidth);
            subMonitor.setWorkRemaining(100);
        } while (segmentWidth != null);
        return null;
    }

    public static List<NoiseSegment> getNoiseSegments(IChromatogram<?> chromatogram, IScanRange range, boolean includeBorders, IProgressMonitor monitor) {
        NoiseSegmentMeasurementResult noiseSegmentMeasurementResult = (NoiseSegmentMeasurementResult)chromatogram.getMeasurementResult(NoiseSegmentMeasurementResult.class);
        if (noiseSegmentMeasurementResult == null && (noiseSegmentMeasurementResult = NoiseChromatogramClassifier.applyNoiseSettings(chromatogram, new NoiseChromatogramClassifierSettings(), monitor)) == null) {
            return Collections.emptyList();
        }
        return noiseSegmentMeasurementResult.getSegments(range, includeBorders);
    }
}

