/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.RetentionTimeFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.IFilterWizardPage;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FilterRetentionTimeWizardPage
extends WizardPage
implements IFilterWizardPage {
    private DataBindingContext dbc = new DataBindingContext();
    private int filterType;
    private List<int[]> intervals;
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
    private IObservableValue<Double> observeBegin = new WritableValue();
    private IObservableValue<Double> observeFinish = new WritableValue();
    private RetentionTimeFilter retentionTimeFilter;
    private TableViewer tableViewer;

    public FilterRetentionTimeWizardPage(RetentionTimeFilter retentionTimeFilter) {
        super("Retention time interval filter");
        this.setTitle("Retention Time Interval Filter");
        this.filterType = retentionTimeFilter.getFiltrationType();
        this.intervals = retentionTimeFilter.copyInterval();
        this.retentionTimeFilter = retentionTimeFilter;
        this.observeBegin.setValue((Object)0.0);
        this.observeFinish.setValue((Object)10.0);
    }

    private void addFilterRetentionTimeInterval() {
        int begin = (int)((Double)this.observeBegin.getValue() * 60000.0);
        int finish = (int)((Double)this.observeFinish.getValue() * 60000.0);
        this.intervals.add(new int[]{begin, finish});
        this.setPageComplete(!this.intervals.isEmpty());
        this.updateTable();
    }

    private void createColumns() {
        String[] titles = new String[]{"Start Time (Mintes)", "End Time (Mintes)"};
        int[] bounds = new int[]{50, 50};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0]);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int[] i = (int[])cell.getElement();
                double v = (double)i[0] / 60000.0;
                cell.setText(FilterRetentionTimeWizardPage.this.nf.format(v));
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1]);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int[] i = (int[])cell.getElement();
                double v = (double)i[1] / 60000.0;
                cell.setText(FilterRetentionTimeWizardPage.this.nf.format(v));
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Button button = new Button(composite, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
        button.setText("Select intervals");
        button.addListener(13, e -> {
            int n = this.filterType = 0;
        });
        button.setSelection(this.filterType == 0);
        button = new Button(composite, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
        button.setText("Deselect intervals");
        button.addListener(13, e -> {
            int n = this.filterType = 1;
        });
        button.setSelection(this.filterType == 1);
        Label label = new Label(composite, 0);
        label.setText("Set time interval parametrs:");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        label = new Label(composite, 0);
        label.setText("Start Time of Interval (minutes)");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        Text text = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        ISWTObservableValue targetObservableValue = WidgetProperties.text((int)24).observe((Widget)text);
        UpdateValueStrategy targetToModel = UpdateValueStrategy.create((IConverter)IConverter.create(String.class, Double.class, o1 -> {
            try {
                return this.nf.parse((String)o1).doubleValue();
            }
            catch (ParseException parseException) {
                return null;
            }
        }));
        targetToModel.setBeforeSetValidator(o1 -> {
            Double d;
            if (o1 instanceof Double && (d = (Double)o1) >= 0.0) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)"error");
        });
        UpdateValueStrategy modelToTarget = UpdateValueStrategy.create((IConverter)IConverter.create(Double.class, String.class, o1 -> {
            try {
                return this.nf.format(o1);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }));
        this.dbc.bindValue((IObservableValue)targetObservableValue, this.observeBegin, targetToModel, modelToTarget);
        label = new Label(composite, 0);
        label.setText("End Time of Interval (minutes)");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        text = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        targetObservableValue = WidgetProperties.text((int)24).observe((Widget)text);
        targetToModel = UpdateValueStrategy.create((IConverter)IConverter.create(String.class, Double.class, o1 -> {
            try {
                return this.nf.parse((String)o1).doubleValue();
            }
            catch (ParseException parseException) {
                return null;
            }
        }));
        targetToModel.setBeforeSetValidator(o1 -> {
            Double d;
            if (o1 instanceof Double && (d = (Double)o1) >= 0.0) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)"error");
        });
        modelToTarget = UpdateValueStrategy.create((IConverter)IConverter.create(Double.class, String.class, o1 -> {
            try {
                return this.nf.format(o1);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }));
        this.dbc.bindValue((IObservableValue)targetObservableValue, this.observeFinish, targetToModel, modelToTarget);
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

            protected IStatus validate() {
                if ((Double)FilterRetentionTimeWizardPage.this.observeBegin.getValue() < (Double)FilterRetentionTimeWizardPage.this.observeFinish.getValue()) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.error((String)"error");
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 1).applyTo((Control)buttonComposite);
        buttonComposite.setLayout((Layout)new FillLayout());
        button = new Button(buttonComposite, 8);
        button.setText("Add Interval to Table");
        button.addListener(13, e -> this.addFilterRetentionTimeInterval());
        AggregateValidationStatus aggregateValidationStatus = new AggregateValidationStatus((IObservableCollection)this.dbc.getBindings(), 2);
        IObservableValue isValidationOk = ComputedValue.create(() -> ((IStatus)aggregateValidationStatus.getValue()).isOK());
        ISWTObservableValue buttonEnabledObservable = WidgetProperties.enabled().observe((Widget)button);
        this.dbc.bindValue((IObservableValue)buttonEnabledObservable, isValidationOk);
        button = new Button(buttonComposite, 8);
        button.setText("Remove Selected Intervals");
        button.addListener(13, e -> this.removeFilterRetentionTimeInterval());
        Table table = new Table(composite, 65538);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).minSize(200, 300).applyTo((Control)table);
        this.tableViewer = new TableViewer(table);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.intervals);
        this.updateTable();
        this.setControl((Control)composite);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void removeFilterRetentionTimeInterval() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        for (int[] sel : selection) {
            this.intervals.remove(sel);
        }
        this.setPageComplete(!this.intervals.isEmpty());
        this.updateTable();
    }

    @Override
    public void update() {
        List intervals = this.retentionTimeFilter.getIntervals();
        intervals.clear();
        intervals.addAll(this.intervals);
        this.retentionTimeFilter.setFiltrationType(this.filterType);
    }

    private void updateTable() {
        this.tableViewer.refresh();
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }
}

